/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.versionmigrator.internal;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.versionmigrator.ClassRefactor;
import org.apache.tapestry5.versionmigrator.FileRefactorCommitParser;

public class ArtifactChangeRefactorCommitParser
implements FileRefactorCommitParser {
    public static final String EXAMPLE = "{tapestry-ioc => tapestry5-annotations}/src/main/java/org/apache/tapestry5/ioc/annotations/Advise.java";
    private static final Pattern PATTERN = Pattern.compile("\\{(.*)\\s=>\\s([^}]*)}\\/([^\\.]*).*");

    @Override
    public Optional<ClassRefactor> apply(String line) {
        Matcher matcher = PATTERN.matcher(line);
        ClassRefactor move = null;
        if (matcher.matches()) {
            String className = FileRefactorCommitParser.extractPackageOrClassName(matcher.group(3));
            String sourceArtifactName = matcher.group(1);
            String destinationArtifactName = matcher.group(2);
            move = new ClassRefactor(className, className, sourceArtifactName, destinationArtifactName);
        }
        return Optional.ofNullable(move);
    }
}

