/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.util.Collection;
import java.util.Comparator;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.commons.services.TypeCoercer;
import org.apache.tapestry5.commons.util.ExceptionUtils;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.internal.InternalComponentResources;
import org.apache.tapestry5.internal.bindings.LiteralBinding;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.internal.transform.ParameterConduit;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.MethodHandle;
import org.apache.tapestry5.plastic.MethodInvocationResult;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.services.BindingSource;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterWorker
implements ComponentClassTransformWorker2 {
    private final Logger logger = LoggerFactory.getLogger(ParameterWorker.class);
    private final ComponentClassCache classCache;
    private final BindingSource bindingSource;
    private final ComponentDefaultProvider defaultProvider;
    private final TypeCoercer typeCoercer;
    private final PerthreadManager perThreadManager;
    private final Comparator<PlasticField> byPrincipalThenName = new Comparator<PlasticField>(){

        @Override
        public int compare(PlasticField o1, PlasticField o2) {
            boolean principal2;
            boolean principal1 = ((Parameter)o1.getAnnotation(Parameter.class)).principal();
            if (principal1 == (principal2 = ((Parameter)o2.getAnnotation(Parameter.class)).principal())) {
                return o1.getName().compareTo(o2.getName());
            }
            return principal1 ? -1 : 1;
        }
    };

    public ParameterWorker(ComponentClassCache classCache, BindingSource bindingSource, ComponentDefaultProvider defaultProvider, TypeCoercer typeCoercer, PerthreadManager perThreadManager) {
        this.classCache = classCache;
        this.bindingSource = bindingSource;
        this.defaultProvider = defaultProvider;
        this.typeCoercer = typeCoercer;
        this.perThreadManager = perThreadManager;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        Flow parametersFields = (Flow)F.flow((Collection)plasticClass.getFieldsWithAnnotation(Parameter.class)).sort(this.byPrincipalThenName);
        for (PlasticField field : parametersFields) {
            this.convertFieldIntoParameter(plasticClass, model, field);
        }
    }

    private void convertFieldIntoParameter(PlasticClass plasticClass, MutableComponentModel model, PlasticField field) {
        Parameter annotation = (Parameter)field.getAnnotation(Parameter.class);
        String fieldType = field.getTypeName();
        String parameterName = ParameterWorker.getParameterName(field.getName(), annotation.name());
        field.claim((Object)annotation);
        model.addParameter(parameterName, annotation.required(), annotation.allowNull(), annotation.defaultPrefix(), annotation.cache());
        MethodHandle defaultMethodHandle = this.findDefaultMethodHandle(plasticClass, parameterName);
        ComputedValue<FieldConduit<Object>> computedParameterConduit = this.createComputedParameterConduit(parameterName, fieldType, annotation, defaultMethodHandle);
        field.setComputedConduit(computedParameterConduit);
    }

    private MethodHandle findDefaultMethodHandle(PlasticClass plasticClass, String parameterName) {
        final String methodName = "default" + parameterName;
        Predicate<PlasticMethod> predicate = new Predicate<PlasticMethod>(){

            public boolean accept(PlasticMethod method) {
                return method.getDescription().argumentTypes.length == 0 && method.getDescription().methodName.equalsIgnoreCase(methodName);
            }
        };
        Flow matches = (Flow)F.flow((Collection)plasticClass.getMethods()).filter((Predicate)predicate);
        return matches.isEmpty() ? null : ((PlasticMethod)matches.first()).getHandle();
    }

    private ComputedValue<FieldConduit<Object>> createComputedParameterConduit(final String parameterName, final String fieldTypeName, final Parameter annotation, final MethodHandle defaultMethodHandle) {
        boolean primitive = PlasticUtils.isPrimitive((String)fieldTypeName);
        final boolean allowNull = annotation.allowNull() && !primitive;
        return new ComputedValue<FieldConduit<Object>>(){

            public ParameterConduit get(InstanceContext context) {
                final InternalComponentResources icr = (InternalComponentResources)context.get(InternalComponentResources.class);
                final Class fieldType = ParameterWorker.this.classCache.forName(fieldTypeName);
                final PerThreadValue stateValue = ParameterWorker.this.perThreadManager.createValue();
                return new ParameterConduit(){
                    private Object defaultValue;
                    private Binding parameterBinding;
                    boolean loaded;
                    private boolean invariant;
                    {
                        this.defaultValue = ParameterWorker.this.classCache.defaultValueForType(fieldTypeName);
                        this.loaded = false;
                        this.invariant = false;
                        icr.setParameterConduit(parameterName, this);
                        icr.getPageLifecycleCallbackHub().addPageLoadedCallback(new Runnable(){

                            @Override
                            public void run() {
                                this.load();
                            }
                        });
                    }

                    private ParameterState getState() {
                        ParameterState state = (ParameterState)stateValue.get();
                        if (state == null) {
                            state = new ParameterState();
                            state.value = this.defaultValue;
                            stateValue.set((Object)state);
                        }
                        return state;
                    }

                    private boolean isLoaded() {
                        return this.loaded;
                    }

                    public void set(Object instance, InstanceContext context, Object newValue) {
                        ParameterState state = this.getState();
                        if (!this.loaded) {
                            state.value = newValue;
                            this.defaultValue = newValue;
                            return;
                        }
                        this.writeToBinding(newValue);
                        state.value = newValue;
                        state.cached = annotation.cache() && icr.isRendering();
                    }

                    private Object readFromBinding() {
                        Object result;
                        try {
                            Object boundValue = this.parameterBinding.get();
                            result = ParameterWorker.this.typeCoercer.coerce(boundValue, fieldType);
                        }
                        catch (RuntimeException ex) {
                            throw new TapestryException(String.format("Failure reading parameter '%s' of component %s: %s", parameterName, icr.getCompleteId(), ExceptionUtils.toMessage((Throwable)ex)), (Object)this.parameterBinding, (Throwable)ex);
                        }
                        if (result == null && !allowNull) {
                            throw new TapestryException(String.format("Parameter '%s' of component %s is bound to null. This parameter is not allowed to be null.", parameterName, icr.getCompleteId()), (Object)this.parameterBinding, null);
                        }
                        return result;
                    }

                    private void writeToBinding(Object newValue) {
                        if (this.parameterBinding == null) {
                            return;
                        }
                        try {
                            Object coerced = ParameterWorker.this.typeCoercer.coerce(newValue, this.parameterBinding.getBindingType());
                            this.parameterBinding.set(coerced);
                        }
                        catch (RuntimeException ex) {
                            throw new TapestryException(String.format("Failure writing parameter '%s' of component %s: %s", parameterName, icr.getCompleteId(), ExceptionUtils.toMessage((Throwable)ex)), (Object)icr, (Throwable)ex);
                        }
                    }

                    @Override
                    public void reset() {
                        if (!this.invariant) {
                            this.getState().reset(this.defaultValue);
                        }
                    }

                    public void load() {
                        if (ParameterWorker.this.logger.isDebugEnabled()) {
                            ParameterWorker.this.logger.debug("{} loading parameter {}", (Object)icr.getCompleteId(), (Object)parameterName);
                        }
                        if (!icr.isBound(parameterName)) {
                            if (ParameterWorker.this.logger.isDebugEnabled()) {
                                ParameterWorker.this.logger.debug("{} parameter {} not yet bound", (Object)icr.getCompleteId(), (Object)parameterName);
                            }
                            Binding binding = this.getDefaultBindingForParameter();
                            if (ParameterWorker.this.logger.isDebugEnabled()) {
                                ParameterWorker.this.logger.debug("{} parameter {} bound to default {}", new Object[]{icr.getCompleteId(), parameterName, binding});
                            }
                            if (binding != null) {
                                icr.bindParameter(parameterName, binding);
                            }
                        }
                        this.parameterBinding = icr.getBinding(parameterName);
                        this.loaded = true;
                        this.invariant = this.parameterBinding != null && this.parameterBinding.isInvariant();
                        this.getState().value = this.defaultValue;
                    }

                    @Override
                    public boolean isBound() {
                        return this.parameterBinding != null;
                    }

                    public Object get(Object instance, InstanceContext context) {
                        if (!this.isLoaded()) {
                            return this.defaultValue;
                        }
                        ParameterState state = this.getState();
                        if (state.cached || !this.isBound()) {
                            return state.value;
                        }
                        Object result = this.readFromBinding();
                        if (this.invariant || annotation.cache() && icr.isRendering()) {
                            state.value = result;
                            state.cached = true;
                        }
                        return result;
                    }

                    private Binding getDefaultBindingForParameter() {
                        if (InternalUtils.isNonBlank((String)annotation.value())) {
                            return ParameterWorker.this.bindingSource.newBinding("default " + parameterName, icr, annotation.defaultPrefix(), annotation.value());
                        }
                        if (annotation.autoconnect()) {
                            return ParameterWorker.this.defaultProvider.defaultBinding(parameterName, icr);
                        }
                        this.invokeDefaultMethod();
                        return this.parameterBinding;
                    }

                    private void invokeDefaultMethod() {
                        if (defaultMethodHandle == null) {
                            return;
                        }
                        if (ParameterWorker.this.logger.isDebugEnabled()) {
                            ParameterWorker.this.logger.debug("{} invoking method {} to obtain default for parameter {}", new Object[]{icr.getCompleteId(), defaultMethodHandle, parameterName});
                        }
                        MethodInvocationResult result = defaultMethodHandle.invoke((Object)icr.getComponent(), new Object[0]);
                        result.rethrow();
                        Object defaultValue = result.getReturnValue();
                        if (defaultValue == null) {
                            return;
                        }
                        if (defaultValue instanceof Binding) {
                            this.parameterBinding = (Binding)defaultValue;
                            return;
                        }
                        this.parameterBinding = new LiteralBinding(null, "default " + parameterName, defaultValue);
                    }
                };
            }
        };
    }

    private static String getParameterName(String fieldName, String annotatedName) {
        if (InternalUtils.isNonBlank((String)annotatedName)) {
            return annotatedName;
        }
        return InternalUtils.stripMemberName((String)fieldName);
    }

    private final class ParameterState {
        boolean cached;
        Object value;

        private ParameterState() {
        }

        void reset(Object defaultValue) {
            this.cached = false;
            this.value = defaultValue;
        }
    }
}

