/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.internal.InternalComponentResources;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class PersistWorker
implements ComponentClassTransformWorker2 {
    private final ComponentClassCache classCache;
    private final PerthreadManager perThreadManager;

    public PersistWorker(ComponentClassCache classCache, PerthreadManager perThreadManager) {
        this.classCache = classCache;
        this.perThreadManager = perThreadManager;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(Persist.class)) {
            this.makeFieldPersistent(field, model);
        }
    }

    private void makeFieldPersistent(PlasticField field, MutableComponentModel model) {
        Persist annotation = (Persist)field.getAnnotation(Persist.class);
        field.claim((Object)annotation);
        final String logicalFieldName = model.setFieldPersistenceStrategy(field.getName(), annotation.value());
        final Object defaultValue = this.determineDefaultValueFromFieldType(field);
        ComputedValue<FieldConduit<Object>> computed = new ComputedValue<FieldConduit<Object>>(){

            public FieldConduit<Object> get(InstanceContext context) {
                InternalComponentResources resources = (InternalComponentResources)context.get(InternalComponentResources.class);
                return new PersistentFieldConduit(resources, logicalFieldName, defaultValue);
            }
        };
        field.setComputedConduit((ComputedValue)computed);
    }

    private Object determineDefaultValueFromFieldType(PlasticField field) {
        return this.classCache.defaultValueForType(field.getTypeName());
    }

    class PersistentFieldConduit
    implements FieldConduit<Object> {
        private final InternalComponentResources resources;
        private final String name;
        private final PerThreadValue<Object> fieldValue;
        private final Object defaultValue;

        public PersistentFieldConduit(InternalComponentResources resources, String name, Object defaultValue) {
            this.fieldValue = PersistWorker.this.perThreadManager.createValue();
            this.resources = resources;
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public Object get(Object instance, InstanceContext context) {
            if (!this.fieldValue.exists()) {
                Object persistedValue = this.resources.hasFieldChange(this.name) ? this.resources.getFieldChange(this.name) : this.defaultValue;
                this.fieldValue.set(persistedValue);
            }
            return this.fieldValue.get();
        }

        public void set(Object instance, InstanceContext context, Object newValue) {
            this.resources.persistFieldChange(this.name, newValue);
            this.fieldValue.set(newValue);
        }
    }
}

