/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.extractor.DocumentSelector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.util.PropsUtil;

public class FSDocumentSelector
implements DocumentSelector {
    private final Pattern includeFileName;
    private final Pattern excludeFileName;
    private final long maxFileSizeBytes;
    private final long minFileSizeBytes;

    public FSDocumentSelector(Pattern includeFileName, Pattern excludeFileName, long minFileSizeBytes, long maxFileSizeBytes) {
        this.includeFileName = includeFileName;
        this.excludeFileName = excludeFileName;
        this.minFileSizeBytes = minFileSizeBytes;
        this.maxFileSizeBytes = maxFileSizeBytes;
    }

    @Override
    public boolean select(Metadata metadata) {
        Matcher m;
        String fName = metadata.get("resourceName");
        long sz = PropsUtil.getLong(metadata.get("Content-Length"), -1L);
        if (this.maxFileSizeBytes > -1L && sz > 0L && sz > this.maxFileSizeBytes) {
            return false;
        }
        if (this.minFileSizeBytes > -1L && sz > 0L && sz < this.minFileSizeBytes) {
            return false;
        }
        if (this.excludeFileName != null && fName != null && (m = this.excludeFileName.matcher(fName)).find()) {
            return false;
        }
        if (this.includeFileName != null && fName != null) {
            m = this.includeFileName.matcher(fName);
            return m.find();
        }
        return true;
    }
}

