/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.nio.DoubleBuffer;
import org.apache.sis.image.LanczosInterpolation;

public abstract class Interpolation {
    public static final Interpolation NEAREST = new Interpolation(){

        public String toString() {
            return "NEAREST";
        }

        @Override
        public Dimension getSupportSize() {
            return new Dimension(1, 1);
        }

        @Override
        public void interpolate(DoubleBuffer source, int numBands, double xfrac, double yfrac, double[] writeTo, int writeToOffset) {
            source.mark();
            source.get(writeTo, writeToOffset, numBands);
            source.reset();
        }

        @Override
        Interpolation toCompatible(RenderedImage source) {
            return this;
        }
    };
    public static final Interpolation BILINEAR = new Interpolation(){

        public String toString() {
            return "BILINEAR";
        }

        @Override
        public Dimension getSupportSize() {
            return new Dimension(2, 2);
        }

        @Override
        public void interpolate(DoubleBuffer source, int numBands, double xfrac, double yfrac, double[] writeTo, int writeToOffset) {
            double mx = 1.0 - xfrac;
            double my = 1.0 - yfrac;
            for (int b = 0; b < numBands; ++b) {
                int p = source.position() + b;
                double d = source.get(p) * mx;
                p = p + numBands;
                double y = (d + source.get(p) * xfrac) * my + (source.get(p += numBands) * mx + source.get(p + numBands) * xfrac) * yfrac;
                if (Double.isNaN(y)) {
                    p = source.position() + b;
                    if (xfrac >= 0.5) {
                        p += numBands;
                    }
                    if (yfrac >= 0.5) {
                        p += numBands * 2;
                    }
                    y = source.get(p);
                }
                writeTo[writeToOffset++] = y;
            }
        }
    };
    public static final Interpolation LANCZOS = new LanczosInterpolation(3);

    protected Interpolation() {
    }

    public abstract Dimension getSupportSize();

    public abstract void interpolate(DoubleBuffer var1, int var2, double var3, double var5, double[] var7, int var8);

    Interpolation toCompatible(RenderedImage source) {
        return source.getColorModel() instanceof IndexColorModel ? NEAREST : this;
    }
}

