/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sis.converter.SurjectiveConverter;
import org.apache.sis.metadata.simple.SimpleAttributeType;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.DefaultRecordType;
import org.apache.sis.util.iso.TypeNames;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameSpace;
import org.opengis.util.RecordSchema;
import org.opengis.util.RecordType;
import org.opengis.util.Type;
import org.opengis.util.TypeName;

public class DefaultRecordSchema
implements RecordSchema {
    protected final DefaultNameFactory nameFactory;
    private final NameSpace namespace;
    private final Map<TypeName, RecordType> description;
    private final ConcurrentMap<Class<?>, Type> attributeTypes;
    private final ObjectConverter<Class<?>, Type> toTypes = new SurjectiveConverter<Class<?>, Type>(){

        @Override
        public Class<Class<?>> getSourceClass() {
            return Class.class;
        }

        @Override
        public Class<Type> getTargetClass() {
            return Type.class;
        }

        @Override
        public Type apply(Class<?> valueClass) {
            return DefaultRecordSchema.this.toAttributeType(valueClass);
        }
    };

    public DefaultRecordSchema(DefaultNameFactory nameFactory, NameSpace parent, CharSequence schemaName) {
        ArgumentChecks.ensureNonNull("schemaName", schemaName);
        if (nameFactory == null) {
            nameFactory = DefaultNameFactory.provider();
        }
        this.nameFactory = nameFactory;
        this.namespace = nameFactory.createNameSpace(nameFactory.createLocalName(parent, schemaName), null);
        this.description = new WeakValueHashMap<TypeName, RecordType>(TypeName.class);
        this.attributeTypes = new ConcurrentHashMap();
    }

    @Override
    public LocalName getSchemaName() {
        return this.namespace.name().tip();
    }

    public TypeName createRecordTypeName(CharSequence typeName) {
        ArgumentChecks.ensureNonNull("typeName", typeName);
        return this.nameFactory.createTypeName(this.namespace, typeName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordType createRecordType(CharSequence typeName, Map<CharSequence, Class<?>> fields) throws IllegalArgumentException {
        boolean hasNext;
        RecordType record;
        ArgumentChecks.ensureNonNull("fields", fields);
        TypeName name = this.createRecordTypeName(typeName);
        Map<CharSequence, Type> fieldTypes = ObjectConverters.derivedValues(fields, CharSequence.class, this.toTypes);
        Map<TypeName, RecordType> map = this.description;
        synchronized (map) {
            record = this.description.get(typeName);
            if (record == null) {
                record = new DefaultRecordType(name, this, fieldTypes, this.nameFactory);
                this.description.put(name, record);
                return record;
            }
        }
        Iterator<Map.Entry<CharSequence, Class<?>>> it1 = fields.entrySet().iterator();
        Iterator<Map.Entry<MemberName, Type>> it2 = record.getMemberTypes().entrySet().iterator();
        while ((hasNext = it1.hasNext()) == it2.hasNext()) {
            if (!hasNext) {
                return record;
            }
            Map.Entry<CharSequence, Class<?>> e1 = it1.next();
            Map.Entry<MemberName, Type> e2 = it2.next();
            if (e2.getKey().tip().toString().equals(e1.toString()) && ((SimpleAttributeType)e2.getValue()).getValueClass().equals(e1.getValue())) continue;
            break;
        }
        throw new IllegalArgumentException(Errors.format((short)121, this.getSchemaName(), typeName));
    }

    final Type toAttributeType(Class<?> valueClass) {
        if (!TypeNames.isValid(valueClass)) {
            return null;
        }
        SimpleAttributeType type = (SimpleAttributeType)this.attributeTypes.get(valueClass);
        if (type == null) {
            if (valueClass == Void.TYPE) {
                throw new IllegalArgumentException(Errors.format((short)45, "valueClass", "void"));
            }
            TypeName name = this.nameFactory.toTypeName(valueClass);
            type = new SimpleAttributeType(name, valueClass);
            Type old = this.attributeTypes.putIfAbsent(valueClass, type);
            if (old != null) {
                return old;
            }
        }
        return type;
    }

    @Override
    public Map<TypeName, RecordType> getDescription() {
        return Collections.unmodifiableMap(this.description);
    }

    @Override
    public RecordType locate(TypeName name) {
        return this.description.get(name);
    }

    public String toString() {
        return Strings.bracket("RecordSchema", (Object)this.getSchemaName());
    }
}

