/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.FromToModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.GType;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.Writing;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.EventUtil;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.ListCallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public class AddEdgeStep<S>
extends ScalarMapStep<S, Edge>
implements Writing<Event.EdgeAddedEvent>,
TraversalParent,
Scoping,
FromToModulating {
    private static final String FROM = Graph.Hidden.hide("from");
    private static final String TO = Graph.Hidden.hide("to");
    private Parameters parameters = new Parameters();
    private CallbackRegistry<Event.EdgeAddedEvent> callbackRegistry;

    public AddEdgeStep(Traversal.Admin traversal, String edgeLabel) {
        super(traversal);
        this.parameters.set(this, T.label, GValue.of(null, edgeLabel));
    }

    public AddEdgeStep(Traversal.Admin traversal, GValue<String> edgeLabel) {
        super(traversal);
        this.parameters.set(this, T.label, edgeLabel);
    }

    public AddEdgeStep(Traversal.Admin traversal, Traversal.Admin<S, String> edgeLabelTraversal) {
        super(traversal);
        this.parameters.set(this, T.label, edgeLabelTraversal);
    }

    @Override
    public <S, E> List<Traversal.Admin<S, E>> getLocalChildren() {
        return this.parameters.getTraversals();
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Set<String> getScopeKeys() {
        return this.parameters.getReferencedLabels();
    }

    @Override
    public void configure(Object ... keyValues) {
        this.parameters.set(this, keyValues);
    }

    @Override
    public void addTo(Traversal.Admin<?, ?> toObject) {
        this.parameters.set(this, TO, toObject);
    }

    @Override
    public void addFrom(Traversal.Admin<?, ?> fromObject) {
        this.parameters.set(this, FROM, fromObject);
    }

    @Override
    protected Edge map(Traverser.Admin<S> traverser) {
        Object theFrom;
        Object theTo;
        GValue<String> literalOrVar = this.parameters.get(traverser, T.label, () -> GValue.of(null, "edge")).get(0);
        GValue<String> edgeLabel = literalOrVar instanceof String ? GValue.ofString(null, (String)((Object)literalOrVar)) : literalOrVar;
        try {
            theTo = this.parameters.get(traverser, TO, traverser::get).get(0);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("addE(%s) failed because the to() traversal (which should give a Vertex) failed with: %s", edgeLabel, e.getMessage()));
        }
        if (!GValue.instanceOf(theTo, GType.VERTEX)) {
            throw new IllegalStateException(String.format("The value given to addE(%s).to() must resolve to a Vertex but %s was specified instead", edgeLabel, null == theTo ? "null" : theTo.getClass().getSimpleName()));
        }
        try {
            theFrom = this.parameters.get(traverser, FROM, traverser::get).get(0);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("addE(%s) failed because the from() traversal (which should give a Vertex) failed with: %s", edgeLabel, e.getMessage()));
        }
        if (!GValue.instanceOf(theFrom, GType.VERTEX)) {
            throw new IllegalStateException(String.format("The value given to addE(%s).to() must resolve to a Vertex but %s was specified instead", edgeLabel, null == theFrom ? "null" : theFrom.getClass().getSimpleName()));
        }
        Vertex toVertex = (Vertex)GValue.getFrom(theTo);
        Vertex fromVertex = (Vertex)GValue.getFrom(theFrom);
        if (toVertex instanceof Attachable) {
            toVertex = (Vertex)((Attachable)((Object)toVertex)).attach(Attachable.Method.get(this.getTraversal().getGraph().orElse(EmptyGraph.instance())));
        }
        if (fromVertex instanceof Attachable) {
            fromVertex = (Vertex)((Attachable)((Object)fromVertex)).attach(Attachable.Method.get(this.getTraversal().getGraph().orElse(EmptyGraph.instance())));
        }
        Edge edge = fromVertex.addEdge(edgeLabel.get(), toVertex, this.parameters.getKeyValues(traverser, TO, FROM, T.label));
        EventUtil.registerEdgeCreation(this.callbackRegistry, this.getTraversal(), edge);
        return edge;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT);
    }

    @Override
    public CallbackRegistry<Event.EdgeAddedEvent> getMutatingCallbackRegistry() {
        if (null == this.callbackRegistry) {
            this.callbackRegistry = new ListCallbackRegistry<Event.EdgeAddedEvent>();
        }
        return this.callbackRegistry;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.parameters.hashCode();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.parameters.toString());
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.parameters.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public AddEdgeStep<S> clone() {
        AddEdgeStep clone = (AddEdgeStep)super.clone();
        clone.parameters = this.parameters.clone();
        return clone;
    }
}

