/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.juli.logging.Log;

public class DataSourceStore
extends StoreBase {
    private String name = null;
    protected static final String storeName = "dataSourceStore";
    protected String dataSourceName = null;
    private boolean localDataSource = false;
    protected DataSource dataSource = null;
    protected String sessionTable = "tomcat$sessions";
    protected String sessionAppCol = "app";
    protected String sessionIdCol = "id";
    protected String sessionDataCol = "data";
    protected String sessionValidCol = "valid";
    protected String sessionMaxInactiveCol = "maxinactive";
    protected String sessionLastAccessedCol = "lastaccess";

    public String getName() {
        if (this.name == null) {
            Context container = this.manager.getContext();
            Object contextName = container.getName();
            if (!((String)contextName).startsWith("/")) {
                contextName = "/" + (String)contextName;
            }
            String hostName = "";
            String engineName = "";
            if (container.getParent() != null) {
                Container host = container.getParent();
                hostName = host.getName();
                if (host.getParent() != null) {
                    engineName = host.getParent().getName();
                }
            }
            this.name = "/" + engineName + "/" + hostName + (String)contextName;
        }
        return this.name;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setSessionTable(String sessionTable) {
        String oldSessionTable = this.sessionTable;
        this.sessionTable = sessionTable;
        this.support.firePropertyChange("sessionTable", oldSessionTable, this.sessionTable);
    }

    public String getSessionTable() {
        return this.sessionTable;
    }

    public void setSessionAppCol(String sessionAppCol) {
        String oldSessionAppCol = this.sessionAppCol;
        this.sessionAppCol = sessionAppCol;
        this.support.firePropertyChange("sessionAppCol", oldSessionAppCol, this.sessionAppCol);
    }

    public String getSessionAppCol() {
        return this.sessionAppCol;
    }

    public void setSessionIdCol(String sessionIdCol) {
        String oldSessionIdCol = this.sessionIdCol;
        this.sessionIdCol = sessionIdCol;
        this.support.firePropertyChange("sessionIdCol", oldSessionIdCol, this.sessionIdCol);
    }

    public String getSessionIdCol() {
        return this.sessionIdCol;
    }

    public void setSessionDataCol(String sessionDataCol) {
        String oldSessionDataCol = this.sessionDataCol;
        this.sessionDataCol = sessionDataCol;
        this.support.firePropertyChange("sessionDataCol", oldSessionDataCol, this.sessionDataCol);
    }

    public String getSessionDataCol() {
        return this.sessionDataCol;
    }

    public void setSessionValidCol(String sessionValidCol) {
        String oldSessionValidCol = this.sessionValidCol;
        this.sessionValidCol = sessionValidCol;
        this.support.firePropertyChange("sessionValidCol", oldSessionValidCol, this.sessionValidCol);
    }

    public String getSessionValidCol() {
        return this.sessionValidCol;
    }

    public void setSessionMaxInactiveCol(String sessionMaxInactiveCol) {
        String oldSessionMaxInactiveCol = this.sessionMaxInactiveCol;
        this.sessionMaxInactiveCol = sessionMaxInactiveCol;
        this.support.firePropertyChange("sessionMaxInactiveCol", oldSessionMaxInactiveCol, this.sessionMaxInactiveCol);
    }

    public String getSessionMaxInactiveCol() {
        return this.sessionMaxInactiveCol;
    }

    public void setSessionLastAccessedCol(String sessionLastAccessedCol) {
        String oldSessionLastAccessedCol = this.sessionLastAccessedCol;
        this.sessionLastAccessedCol = sessionLastAccessedCol;
        this.support.firePropertyChange("sessionLastAccessedCol", oldSessionLastAccessedCol, this.sessionLastAccessedCol);
    }

    public String getSessionLastAccessedCol() {
        return this.sessionLastAccessedCol;
    }

    public void setDataSourceName(String dataSourceName) {
        if (dataSourceName == null || dataSourceName.trim().isEmpty()) {
            this.manager.getContext().getLogger().warn(sm.getString(this.getStoreName() + ".missingDataSourceName"));
            return;
        }
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public boolean getLocalDataSource() {
        return this.localDataSource;
    }

    public void setLocalDataSource(boolean localDataSource) {
        this.localDataSource = localDataSource;
    }

    public String[] expiredKeys() throws IOException {
        return this.keys(true);
    }

    public String[] keys() throws IOException {
        return this.keys(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] keys(boolean expiredOnly) {
        String[] keys = null;
        for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
            Connection _conn = this.getConnection();
            if (_conn == null) {
                return new String[0];
            }
            try {
                String keysSql = "SELECT " + this.sessionIdCol + " FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
                if (expiredOnly) {
                    keysSql = keysSql + " AND (" + this.sessionLastAccessedCol + " + " + this.sessionMaxInactiveCol + " * 1000 < ?)";
                }
                try (PreparedStatement preparedKeysSql = _conn.prepareStatement(keysSql);){
                    preparedKeysSql.setString(1, this.getName());
                    if (expiredOnly) {
                        preparedKeysSql.setLong(2, System.currentTimeMillis());
                    }
                    try (ResultSet rst = preparedKeysSql.executeQuery();){
                        ArrayList<String> tmpkeys = new ArrayList<String>();
                        if (rst != null) {
                            while (rst.next()) {
                                tmpkeys.add(rst.getString(1));
                            }
                        }
                        keys = tmpkeys.toArray(new String[0]);
                        numberOfTries = 0;
                        continue;
                    }
                }
            }
            catch (SQLException e) {
                this.manager.getContext().getLogger().error(sm.getString("dataSourceStore.SQLException"), e);
                keys = new String[]{};
                continue;
            }
            finally {
                this.release(_conn);
            }
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws IOException {
        int size = 0;
        String sizeSql = "SELECT COUNT(" + this.sessionIdCol + ") FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
        for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
            Connection _conn = this.getConnection();
            if (_conn == null) {
                return size;
            }
            try (PreparedStatement preparedSizeSql = _conn.prepareStatement(sizeSql);){
                preparedSizeSql.setString(1, this.getName());
                try (ResultSet rst = preparedSizeSql.executeQuery();){
                    if (rst.next()) {
                        size = rst.getInt(1);
                    }
                    numberOfTries = 0;
                    continue;
                }
            }
            catch (SQLException e) {
                this.manager.getContext().getLogger().error(sm.getString("dataSourceStore.SQLException"), e);
                continue;
            }
            finally {
                this.release(_conn);
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session load(String id) throws ClassNotFoundException, IOException {
        StandardSession _session = null;
        Context context = this.getManager().getContext();
        Log contextLog = context.getLogger();
        String loadSql = "SELECT " + this.sessionIdCol + ", " + this.sessionDataCol + " FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ? AND " + this.sessionAppCol + " = ?";
        for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
            Connection _conn = this.getConnection();
            if (_conn == null) {
                return null;
            }
            ClassLoader oldThreadContextCL = context.bind(Globals.IS_SECURITY_ENABLED, null);
            try (PreparedStatement preparedLoadSql = _conn.prepareStatement(loadSql);){
                preparedLoadSql.setString(1, id);
                preparedLoadSql.setString(2, this.getName());
                try (ResultSet rst = preparedLoadSql.executeQuery();){
                    if (rst.next()) {
                        try (ObjectInputStream ois = this.getObjectInputStream(rst.getBinaryStream(2));){
                            if (contextLog.isTraceEnabled()) {
                                contextLog.trace(sm.getString("dataSourceStore.loading", id, this.sessionTable));
                            }
                            _session = (StandardSession)this.manager.createEmptySession();
                            _session.readObjectData(ois);
                            _session.setManager(this.manager);
                        }
                    } else if (context.getLogger().isDebugEnabled()) {
                        contextLog.debug(sm.getString("dataSourceStore.noObject", id));
                    }
                    numberOfTries = 0;
                    continue;
                }
            }
            catch (SQLException e) {
                contextLog.error(sm.getString("dataSourceStore.SQLException"), e);
                continue;
            }
            finally {
                context.unbind(Globals.IS_SECURITY_ENABLED, oldThreadContextCL);
                this.release(_conn);
            }
        }
        return _session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) throws IOException {
        for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
            Connection _conn = this.getConnection();
            if (_conn == null) {
                return;
            }
            try {
                this.remove(id, _conn);
                numberOfTries = 0;
                continue;
            }
            catch (SQLException e) {
                this.manager.getContext().getLogger().error(sm.getString("dataSourceStore.SQLException"), e);
                continue;
            }
            finally {
                this.release(_conn);
            }
        }
        if (this.manager.getContext().getLogger().isTraceEnabled()) {
            this.manager.getContext().getLogger().trace(sm.getString("dataSourceStore.removing", id, this.sessionTable));
        }
    }

    private void remove(String id, Connection _conn) throws SQLException {
        String removeSql = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?  AND " + this.sessionAppCol + " = ?";
        try (PreparedStatement preparedRemoveSql = _conn.prepareStatement(removeSql);){
            preparedRemoveSql.setString(1, id);
            preparedRemoveSql.setString(2, this.getName());
            preparedRemoveSql.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        String clearSql = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
        for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
            Connection _conn = this.getConnection();
            if (_conn == null) {
                return;
            }
            try (PreparedStatement preparedClearSql = _conn.prepareStatement(clearSql);){
                preparedClearSql.setString(1, this.getName());
                preparedClearSql.execute();
                numberOfTries = 0;
                continue;
            }
            catch (SQLException e) {
                this.manager.getContext().getLogger().error(sm.getString("dataSourceStore.SQLException"), e);
                continue;
            }
            finally {
                this.release(_conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Session session) throws IOException {
        String saveSql = "INSERT INTO " + this.sessionTable + " (" + this.sessionIdCol + ", " + this.sessionAppCol + ", " + this.sessionDataCol + ", " + this.sessionValidCol + ", " + this.sessionMaxInactiveCol + ", " + this.sessionLastAccessedCol + ") VALUES (?, ?, ?, ?, ?, ?)";
        Session session2 = session;
        synchronized (session2) {
            for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
                Connection _conn = this.getConnection();
                if (_conn == null) {
                    return;
                }
                try {
                    this.remove(session.getIdInternal(), _conn);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(bos));){
                        ((StandardSession)session).writeObjectData(oos);
                    }
                    byte[] obs = bos.toByteArray();
                    int size = obs.length;
                    try (ByteArrayInputStream bis = new ByteArrayInputStream(obs, 0, size);
                         BufferedInputStream in = new BufferedInputStream(bis, size);
                         PreparedStatement preparedSaveSql = _conn.prepareStatement(saveSql);){
                        preparedSaveSql.setString(1, session.getIdInternal());
                        preparedSaveSql.setString(2, this.getName());
                        preparedSaveSql.setBinaryStream(3, (InputStream)in, size);
                        preparedSaveSql.setString(4, session.isValid() ? "1" : "0");
                        preparedSaveSql.setInt(5, session.getMaxInactiveInterval());
                        preparedSaveSql.setLong(6, session.getLastAccessedTime());
                        preparedSaveSql.execute();
                        numberOfTries = 0;
                        continue;
                    }
                }
                catch (SQLException e) {
                    this.manager.getContext().getLogger().error(sm.getString("dataSourceStore.SQLException"), e);
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                finally {
                    this.release(_conn);
                }
            }
        }
        if (this.manager.getContext().getLogger().isTraceEnabled()) {
            this.manager.getContext().getLogger().trace(sm.getString("dataSourceStore.saving", session.getIdInternal(), this.sessionTable));
        }
    }

    protected Connection getConnection() {
        Connection conn = null;
        try {
            conn = this.open();
            if (conn == null || conn.isClosed()) {
                this.manager.getContext().getLogger().info(sm.getString("dataSourceStore.checkConnectionDBClosed"));
                conn = this.open();
                if (conn == null || conn.isClosed()) {
                    this.manager.getContext().getLogger().info(sm.getString("dataSourceStore.checkConnectionDBReOpenFail"));
                }
            }
        }
        catch (SQLException ex) {
            this.manager.getContext().getLogger().error(sm.getString("dataSourceStore.checkConnectionSQLException"), ex);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection open() throws SQLException {
        if (this.dataSourceName != null && this.dataSource == null) {
            Context context = this.getManager().getContext();
            if (this.getLocalDataSource()) {
                ClassLoader oldThreadContextCL = context.bind(Globals.IS_SECURITY_ENABLED, null);
                try {
                    javax.naming.Context envCtx = (javax.naming.Context)new InitialContext().lookup("java:comp/env");
                    this.dataSource = (DataSource)envCtx.lookup(this.dataSourceName);
                }
                catch (NamingException e) {
                    context.getLogger().error(sm.getString("dataSourceStore.wrongDataSource", this.dataSourceName), e);
                }
                finally {
                    context.unbind(Globals.IS_SECURITY_ENABLED, oldThreadContextCL);
                }
            } else {
                try {
                    Server server;
                    Service service = Container.getService(context);
                    if (service != null && (server = service.getServer()) != null) {
                        javax.naming.Context namingContext = server.getGlobalNamingContext();
                        this.dataSource = (DataSource)namingContext.lookup(this.dataSourceName);
                    }
                }
                catch (NamingException service) {
                    // empty catch block
                }
                if (this.dataSource == null) {
                    try {
                        javax.naming.Context envCtx = (javax.naming.Context)new InitialContext().lookup("java:comp/env");
                        this.dataSource = (DataSource)envCtx.lookup(this.dataSourceName);
                    }
                    catch (NamingException e) {
                        context.getLogger().error(sm.getString("dataSourceStore.wrongDataSource", this.dataSourceName), e);
                    }
                }
            }
        }
        if (this.dataSource != null) {
            return this.dataSource.getConnection();
        }
        throw new IllegalStateException(sm.getString("dataSourceStore.missingDataSource"));
    }

    protected void close(Connection dbConnection) {
        if (dbConnection == null) {
            return;
        }
        try {
            if (!dbConnection.getAutoCommit()) {
                dbConnection.commit();
            }
        }
        catch (SQLException e) {
            this.manager.getContext().getLogger().error(sm.getString("dataSourceStore.commitSQLException"), e);
        }
        try {
            dbConnection.close();
        }
        catch (SQLException e) {
            this.manager.getContext().getLogger().error(sm.getString("dataSourceStore.close"), e);
        }
    }

    protected void release(Connection conn) {
        if (this.dataSource != null) {
            this.close(conn);
        }
    }
}

