/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.query.AbstractDomainObject;
import org.apache.openjpa.persistence.query.AliasContext;
import org.apache.openjpa.persistence.query.DomainObject;
import org.apache.openjpa.persistence.query.OpenJPAQueryBuilder;
import org.apache.openjpa.persistence.query.PathExpression;
import org.apache.openjpa.persistence.query.QueryDefinition;
import org.apache.openjpa.persistence.query.QueryDefinitionImpl;

public class QueryBuilderImpl
implements OpenJPAQueryBuilder {
    private final OpenJPAEntityManagerFactorySPI _emf;

    public QueryBuilderImpl(OpenJPAEntityManagerFactorySPI emf) {
        this._emf = emf;
    }

    @Override
    public QueryDefinition createQueryDefinition() {
        return new QueryDefinitionImpl(this);
    }

    @Override
    public DomainObject createQueryDefinition(Class root) {
        return new QueryDefinitionImpl(this).addRoot(root);
    }

    @Override
    public DomainObject createSubqueryDefinition(PathExpression path) {
        return new QueryDefinitionImpl(this).addSubqueryRoot(path);
    }

    @Override
    public String toJPQL(QueryDefinition query) {
        MetaDataRepository repos = this._emf.getConfiguration().getMetaDataRepositoryInstance();
        AliasContext ctx = new AliasContext(repos);
        if (query instanceof AbstractDomainObject) {
            return ((AbstractDomainObject)query).getOwner().asExpression(ctx);
        }
        return ((QueryDefinitionImpl)query).asExpression(ctx);
    }

    @Override
    public QueryDefinition createQueryDefinition(String jpql) {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryDefinition createQueryDefinition(Query jpql) {
        throw new UnsupportedOperationException();
    }
}

