/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.testcontainer;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.fulcrum.testcontainer.ECMContainer;
import org.apache.fulcrum.testcontainer.YAAFIContainer;
import org.apache.fulcrum.yaafi.container.Container;
import org.junit.After;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class BaseUnit4Test {
    public static final String CONTAINER_ECM = "CONTAINER_ECM";
    public static final String CONTAINER_YAAFI = "CONTAINER_YAAFI";
    public static final String COMPONENT_APP_ROOT = "componentAppRoot";
    private String containerType = "CONTAINER_YAAFI";
    public static final int defaultLogLevel = 1;
    private Container container;
    private String configurationFileName = "src/test/TestComponentConfig.xml";
    private String roleFileName = "src/test/TestRoleConfig.xml";
    private String parameterFileName = null;
    private int logLevel = 1;
    public Map<String, Object> attributes = new HashMap<String, Object>();
    public int maxInactiveInterval = 0;

    protected void setConfigurationFileName(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    protected void setRoleFileName(String roleFileName) {
        this.roleFileName = roleFileName;
    }

    protected void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    @After
    public void tearDown() {
        if (this.container != null) {
            this.container.dispose();
        }
        this.container = null;
    }

    protected String getConfigurationFileName() {
        return this.configurationFileName;
    }

    protected String getRoleFileName() {
        return this.roleFileName;
    }

    protected String getParameterFileName() {
        return this.parameterFileName;
    }

    protected Object lookup(String roleName) throws ComponentException {
        if (this.container == null) {
            this.container = this.containerType.equals(CONTAINER_ECM) ? new ECMContainer() : new YAAFIContainer(this.logLevel);
            this.container.startup(this.getConfigurationFileName(), this.getRoleFileName(), this.getParameterFileName());
        }
        return this.container.lookup(roleName);
    }

    protected void release(Object component) {
        if (this.container != null) {
            this.container.release(component);
        }
    }

    protected HttpServletRequest getMockRequest() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        ((HttpSession)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String key = (String)invocation.getArguments()[0];
                return BaseUnit4Test.this.attributes.get(key);
            }
        }).when((Object)session)).getAttribute(ArgumentMatchers.anyString());
        ((HttpSession)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String key = (String)invocation.getArguments()[0];
                Object value = invocation.getArguments()[1];
                BaseUnit4Test.this.attributes.put(key, value);
                return null;
            }
        }).when((Object)session)).setAttribute(ArgumentMatchers.anyString(), ArgumentMatchers.any());
        Mockito.when((Object)session.getMaxInactiveInterval()).thenReturn((Object)this.maxInactiveInterval);
        ((HttpSession)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) throws Throwable {
                return BaseUnit4Test.this.maxInactiveInterval;
            }
        }).when((Object)session)).getMaxInactiveInterval();
        ((HttpSession)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Integer value = (Integer)invocation.getArguments()[0];
                BaseUnit4Test.this.maxInactiveInterval = value;
                return null;
            }
        }).when((Object)session)).setMaxInactiveInterval(ArgumentMatchers.anyInt());
        Mockito.when((Object)session.isNew()).thenReturn((Object)true);
        Mockito.when((Object)request.getSession()).thenReturn((Object)session);
        Mockito.when((Object)request.getServerName()).thenReturn((Object)"bob");
        Mockito.when((Object)request.getProtocol()).thenReturn((Object)"http");
        Mockito.when((Object)request.getScheme()).thenReturn((Object)"scheme");
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"damn");
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"damn2");
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"wow");
        Mockito.when((Object)request.getContentType()).thenReturn((Object)"text/html");
        Mockito.when((Object)request.getCharacterEncoding()).thenReturn((Object)"US-ASCII");
        Mockito.when((Object)request.getServerPort()).thenReturn((Object)8080);
        Mockito.when((Object)request.getLocale()).thenReturn((Object)Locale.US);
        Mockito.when((Object)request.getHeader("Content-type")).thenReturn((Object)"text/html");
        Mockito.when((Object)request.getHeader("Accept-Language")).thenReturn((Object)"en-US");
        Vector v = new Vector();
        Mockito.when((Object)request.getParameterNames()).thenReturn(v.elements());
        return request;
    }

    public String getContainerType() {
        return this.containerType;
    }

    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }
}

