/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security.peer;

import com.workingdogs.village.Record;
import java.util.ArrayList;
import java.util.List;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.TurbineRole;
import org.apache.turbine.om.security.User;
import org.apache.turbine.om.security.peer.UserGroupRolePeer;
import org.apache.turbine.util.db.map.TurbineMapBuilder;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.RoleSet;

public class RolePeer
extends BasePeer {
    private static final long serialVersionUID = 8236100811297919996L;
    private static final TurbineMapBuilder MAP_BUILDER;
    private static final String TABLE_NAME;
    public static final String ROLE_ID;
    public static final String NAME;
    public static final String OBJECTDATA;

    public static RoleSet retrieveSet(Criteria criteria) throws Exception {
        List results = RolePeer.doSelect(criteria);
        RoleSet rs = new RoleSet();
        for (int i = 0; i < results.size(); ++i) {
            rs.add((Role)results.get(i));
        }
        return rs;
    }

    public static RoleSet retrieveSet(User user, Group group) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(UserGroupRolePeer.USER_ID, (Object)((Persistent)user).getPrimaryKey());
        criteria.add(UserGroupRolePeer.GROUP_ID, (Object)((Persistent)group).getPrimaryKey());
        criteria.addJoin(UserGroupRolePeer.ROLE_ID, ROLE_ID);
        return RolePeer.retrieveSet(criteria);
    }

    public static List doSelect(Criteria criteria) throws TorqueException {
        try {
            criteria.addSelectColumn(ROLE_ID).addSelectColumn(NAME).addSelectColumn(OBJECTDATA);
            if (criteria.getOrderByColumns() == null || criteria.getOrderByColumns().size() == 0) {
                criteria.addAscendingOrderByColumn(NAME);
            }
            List rows = BasePeer.doSelect((Criteria)criteria);
            ArrayList<TurbineRole> results = new ArrayList<TurbineRole>();
            for (int i = 0; i < rows.size(); ++i) {
                TurbineRole obj = new TurbineRole();
                Record row = (Record)rows.get(i);
                obj.setPrimaryKey((ObjectKey)new NumberKey(row.getValue(1).asInt()));
                obj.setName(row.getValue(2).asString());
                results.add(obj);
            }
            return results;
        }
        catch (Exception ex) {
            throw new TorqueException((Throwable)ex);
        }
    }

    public static Criteria buildCriteria(Role role) {
        Criteria criteria = new Criteria();
        if (!((BaseObject)role).isNew()) {
            criteria.add(ROLE_ID, (Object)((BaseObject)role).getPrimaryKey());
        }
        criteria.add(NAME, (Object)role.getName());
        return criteria;
    }

    public static void doUpdate(Criteria criteria) throws TorqueException {
        Criteria selectCriteria = new Criteria(2);
        selectCriteria.put((Object)ROLE_ID, criteria.remove(ROLE_ID));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria);
    }

    public static boolean checkExists(Role role) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(ROLE_ID);
        criteria.add(NAME, (Object)role.getName());
        List results = BasePeer.doSelect((Criteria)criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple roles named '" + role.getName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static String getTableName() {
        return TABLE_NAME;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(TABLE_NAME);
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    static {
        try {
            MAP_BUILDER = (TurbineMapBuilder)Torque.getMapBuilder((String)TurbineMapBuilder.class.getName());
        }
        catch (TorqueException e) {
            log.error((Object)"Could not initialize Peer", (Throwable)e);
            throw new RuntimeException(e);
        }
        TABLE_NAME = MAP_BUILDER.getTableRole();
        ROLE_ID = MAP_BUILDER.getRole_RoleId();
        NAME = MAP_BUILDER.getRole_Name();
        OBJECTDATA = MAP_BUILDER.getRole_ObjectData();
    }
}

