/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.service.shutdown;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fulcrum.yaafi.framework.util.InputStreamLocator;

public class ShutdownEntry {
    private static final int BUF_SIZE = 1024;
    private String location;
    private byte[] digest;
    private InputStreamLocator locator;
    private boolean isFirstInvocation = true;
    private Logger logger;
    private boolean useSystemExit;

    public ShutdownEntry(Logger logger, File applicationDir, String location, boolean useSystemExit) {
        this.useSystemExit = useSystemExit;
        this.location = location;
        this.locator = new InputStreamLocator(applicationDir);
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChanged() {
        boolean result = false;
        InputStream is = null;
        byte[] currDigest = null;
        try {
            is = this.locate();
            if (is == null) {
                String msg = "Unable to find the following resource : " + this.getLocation();
                this.getLogger().warn(msg);
            } else {
                currDigest = this.getDigest(is);
                is.close();
                is = null;
                if (this.isFirstInvocation()) {
                    this.isFirstInvocation = false;
                    this.getLogger().debug("Storing SHA-1 digest of " + this.getLocation());
                    this.setDigest(currDigest);
                } else if (!ShutdownEntry.equals(this.digest, currDigest)) {
                    this.getLogger().debug("The following resource has changed : " + this.getLocation());
                    this.setDigest(currDigest);
                    result = true;
                }
            }
            boolean msg = result;
            return msg;
        }
        catch (Exception e) {
            String msg = "The ShutdownService encountered an internal error";
            this.getLogger().error(msg, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    String msg = "Can't close the InputStream during error recovery";
                    this.getLogger().error(msg, (Throwable)e);
                }
            }
        }
    }

    public boolean isUseSystemExit() {
        return this.useSystemExit;
    }

    private boolean isFirstInvocation() {
        return this.isFirstInvocation;
    }

    private String getLocation() {
        return this.location;
    }

    private InputStreamLocator getLocator() {
        return this.locator;
    }

    public InputStream locate() throws IOException {
        return this.getLocator().locate(this.getLocation());
    }

    private byte[] getDigest(InputStream is) throws Exception {
        byte[] result = null;
        byte[] content = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ShutdownEntry.copy(is, baos);
        content = baos.toByteArray();
        baos.close();
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        sha1.update(content);
        result = sha1.digest();
        return result;
    }

    private void setDigest(byte[] digest) {
        this.digest = digest;
    }

    private static boolean equals(byte[] lhs, byte[] rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (lhs[i] == rhs[i]) continue;
            return false;
        }
        return true;
    }

    private static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[1024];
        int n = 0;
        int total = 0;
        while ((n = is.read(buf)) > 0) {
            os.write(buf, 0, n);
            total += n;
        }
        is.close();
        os.flush();
        os.close();
    }

    private Logger getLogger() {
        return this.logger;
    }
}

