/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;
import org.apache.turbine.services.security.torque.om.TurbineGroup;
import org.apache.turbine.services.security.torque.om.TurbineGroupPeer;
import org.apache.turbine.services.security.torque.om.TurbineUserGroupRole;
import org.apache.turbine.services.security.torque.om.TurbineUserGroupRolePeer;

public abstract class BaseTurbineGroup
extends BaseObject {
    private static final long serialVersionUID = 1308842746584L;
    private static final TurbineGroupPeer peer = new TurbineGroupPeer();
    private int groupId;
    private String name;
    protected List<TurbineUserGroupRole> collTurbineUserGroupRoles;
    private Criteria lastTurbineUserGroupRolesCriteria = null;
    private static List<String> fieldNames = null;
    private boolean alreadyInSave = false;

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int v) throws TorqueException {
        if (this.groupId != v) {
            this.groupId = v;
            this.setModified(true);
        }
        if (this.collTurbineUserGroupRoles != null) {
            for (int i = 0; i < this.collTurbineUserGroupRoles.size(); ++i) {
                this.collTurbineUserGroupRoles.get(i).setGroupId(v);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        if (!ObjectUtils.equals((Object)this.name, (Object)v)) {
            this.name = v;
            this.setModified(true);
        }
    }

    protected void initTurbineUserGroupRoles() {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = new ArrayList<TurbineUserGroupRole>();
        }
    }

    public void addTurbineUserGroupRole(TurbineUserGroupRole l) throws TorqueException {
        this.getTurbineUserGroupRoles().add(l);
        l.setTurbineGroup((TurbineGroup)this);
    }

    public void addTurbineUserGroupRole(TurbineUserGroupRole l, Connection con) throws TorqueException {
        this.getTurbineUserGroupRoles(con).add(l);
        l.setTurbineGroup((TurbineGroup)this);
    }

    public List<TurbineUserGroupRole> getTurbineUserGroupRoles() throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = this.getTurbineUserGroupRoles(new Criteria(10));
        }
        return this.collTurbineUserGroupRoles;
    }

    public List<TurbineUserGroupRole> getTurbineUserGroupRoles(Criteria criteria) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.collTurbineUserGroupRoles = new ArrayList<TurbineUserGroupRole>();
            } else {
                criteria.add(TurbineUserGroupRolePeer.GROUP_ID, this.getGroupId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria);
            }
        } else if (!this.isNew()) {
            criteria.add(TurbineUserGroupRolePeer.GROUP_ID, this.getGroupId());
            if (!this.lastTurbineUserGroupRolesCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria);
            }
        }
        this.lastTurbineUserGroupRolesCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    public List<TurbineUserGroupRole> getTurbineUserGroupRoles(Connection con) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = this.getTurbineUserGroupRoles(new Criteria(10), con);
        }
        return this.collTurbineUserGroupRoles;
    }

    public List<TurbineUserGroupRole> getTurbineUserGroupRoles(Criteria criteria, Connection con) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.collTurbineUserGroupRoles = new ArrayList<TurbineUserGroupRole>();
            } else {
                criteria.add(TurbineUserGroupRolePeer.GROUP_ID, this.getGroupId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria, con);
            }
        } else if (!this.isNew()) {
            criteria.add(TurbineUserGroupRolePeer.GROUP_ID, this.getGroupId());
            if (!this.lastTurbineUserGroupRolesCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria, con);
            }
        }
        this.lastTurbineUserGroupRolesCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    protected List<TurbineUserGroupRole> getTurbineUserGroupRolesJoinTurbineUser(Criteria criteria) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.collTurbineUserGroupRoles = new ArrayList<TurbineUserGroupRole>();
            } else {
                criteria.add(TurbineUserGroupRolePeer.GROUP_ID, this.getGroupId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineUser(criteria);
            }
        } else {
            criteria.add(TurbineUserGroupRolePeer.GROUP_ID, this.getGroupId());
            if (!this.lastTurbineUserGroupRolesCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineUser(criteria);
            }
        }
        this.lastTurbineUserGroupRolesCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    protected List<TurbineUserGroupRole> getTurbineUserGroupRolesJoinTurbineGroup(Criteria criteria) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.collTurbineUserGroupRoles = new ArrayList<TurbineUserGroupRole>();
            } else {
                criteria.add(TurbineUserGroupRolePeer.GROUP_ID, this.getGroupId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineGroup(criteria);
            }
        } else {
            criteria.add(TurbineUserGroupRolePeer.GROUP_ID, this.getGroupId());
            if (!this.lastTurbineUserGroupRolesCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineGroup(criteria);
            }
        }
        this.lastTurbineUserGroupRolesCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    protected List<TurbineUserGroupRole> getTurbineUserGroupRolesJoinTurbineRole(Criteria criteria) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.collTurbineUserGroupRoles = new ArrayList<TurbineUserGroupRole>();
            } else {
                criteria.add(TurbineUserGroupRolePeer.GROUP_ID, this.getGroupId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineRole(criteria);
            }
        } else {
            criteria.add(TurbineUserGroupRolePeer.GROUP_ID, this.getGroupId());
            if (!this.lastTurbineUserGroupRolesCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineRole(criteria);
            }
        }
        this.lastTurbineUserGroupRolesCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    public static synchronized List<String> getFieldNames() {
        if (fieldNames == null) {
            fieldNames = new ArrayList<String>();
            fieldNames.add("GroupId");
            fieldNames.add("Name");
            fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    public Object getByName(String name) {
        if (name.equals("GroupId")) {
            return new Integer(this.getGroupId());
        }
        if (name.equals("Name")) {
            return this.getName();
        }
        return null;
    }

    public boolean setByName(String name, Object value) throws TorqueException, IllegalArgumentException {
        if (name.equals("GroupId")) {
            if (value == null || !Integer.class.isInstance(value)) {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            this.setGroupId((Integer)value);
            return true;
        }
        if (name.equals("Name")) {
            if (value != null && !String.class.isInstance(value)) {
                throw new IllegalArgumentException("Invalid type of object specified for value in setByName");
            }
            this.setName((String)value);
            return true;
        }
        return false;
    }

    public Object getByPeerName(String name) {
        if (name.equals(TurbineGroupPeer.GROUP_ID)) {
            return new Integer(this.getGroupId());
        }
        if (name.equals(TurbineGroupPeer.GROUP_NAME)) {
            return this.getName();
        }
        return null;
    }

    public boolean setByPeerName(String name, Object value) throws TorqueException, IllegalArgumentException {
        if (TurbineGroupPeer.GROUP_ID.equals(name)) {
            return this.setByName("GroupId", value);
        }
        if (TurbineGroupPeer.GROUP_NAME.equals(name)) {
            return this.setByName("Name", value);
        }
        return false;
    }

    public Object getByPosition(int pos) {
        if (pos == 0) {
            return new Integer(this.getGroupId());
        }
        if (pos == 1) {
            return this.getName();
        }
        return null;
    }

    public boolean setByPosition(int position, Object value) throws TorqueException, IllegalArgumentException {
        if (position == 0) {
            return this.setByName("GroupId", value);
        }
        if (position == 1) {
            return this.setByName("Name", value);
        }
        return false;
    }

    public void save() throws Exception {
        this.save(TurbineGroupPeer.DATABASE_NAME);
    }

    public void save(String dbName) throws TorqueException {
        Connection con = null;
        try {
            con = Transaction.begin((String)dbName);
            this.save(con);
            Transaction.commit((Connection)con);
        }
        catch (TorqueException e) {
            Transaction.safeRollback((Connection)con);
            throw e;
        }
    }

    public void save(Connection con) throws TorqueException {
        if (!this.alreadyInSave) {
            this.alreadyInSave = true;
            if (this.isModified()) {
                if (this.isNew()) {
                    TurbineGroupPeer.doInsert((TurbineGroup)this, con);
                    this.setNew(false);
                } else {
                    TurbineGroupPeer.doUpdate((TurbineGroup)this, con);
                }
            }
            if (this.collTurbineUserGroupRoles != null) {
                for (int i = 0; i < this.collTurbineUserGroupRoles.size(); ++i) {
                    this.collTurbineUserGroupRoles.get(i).save(con);
                }
            }
            this.alreadyInSave = false;
        }
    }

    public void setPrimaryKey(ObjectKey key) throws TorqueException {
        this.setGroupId(((NumberKey)key).intValue());
    }

    public void setPrimaryKey(String key) throws TorqueException {
        this.setGroupId(Integer.parseInt(key));
    }

    public ObjectKey getPrimaryKey() {
        return SimpleKey.keyFor((int)this.getGroupId());
    }

    public TurbineGroup copy() throws TorqueException {
        return this.copy(true);
    }

    public TurbineGroup copy(Connection con) throws TorqueException {
        return this.copy(true, con);
    }

    public TurbineGroup copy(boolean deepcopy) throws TorqueException {
        return this.copyInto(new TurbineGroup(), deepcopy);
    }

    public TurbineGroup copy(boolean deepcopy, Connection con) throws TorqueException {
        return this.copyInto(new TurbineGroup(), deepcopy, con);
    }

    protected TurbineGroup copyInto(TurbineGroup copyObj) throws TorqueException {
        return this.copyInto(copyObj, true);
    }

    protected TurbineGroup copyInto(TurbineGroup copyObj, Connection con) throws TorqueException {
        return this.copyInto(copyObj, true, con);
    }

    protected TurbineGroup copyInto(TurbineGroup copyObj, boolean deepcopy) throws TorqueException {
        copyObj.setGroupId(this.groupId);
        copyObj.setName(this.name);
        copyObj.setGroupId(0);
        if (deepcopy) {
            List<TurbineUserGroupRole> vTurbineUserGroupRoles = this.getTurbineUserGroupRoles();
            if (vTurbineUserGroupRoles != null) {
                for (int i = 0; i < vTurbineUserGroupRoles.size(); ++i) {
                    TurbineUserGroupRole obj = vTurbineUserGroupRoles.get(i);
                    copyObj.addTurbineUserGroupRole(obj.copy());
                }
            } else {
                copyObj.collTurbineUserGroupRoles = null;
            }
        }
        return copyObj;
    }

    protected TurbineGroup copyInto(TurbineGroup copyObj, boolean deepcopy, Connection con) throws TorqueException {
        copyObj.setGroupId(this.groupId);
        copyObj.setName(this.name);
        copyObj.setGroupId(0);
        if (deepcopy) {
            List<TurbineUserGroupRole> vTurbineUserGroupRoles = this.getTurbineUserGroupRoles(con);
            if (vTurbineUserGroupRoles != null) {
                for (int i = 0; i < vTurbineUserGroupRoles.size(); ++i) {
                    TurbineUserGroupRole obj = vTurbineUserGroupRoles.get(i);
                    copyObj.addTurbineUserGroupRole(obj.copy(con), con);
                }
            } else {
                copyObj.collTurbineUserGroupRoles = null;
            }
        }
        return copyObj;
    }

    public TurbineGroupPeer getPeer() {
        return peer;
    }

    public TableMap getTableMap() throws TorqueException {
        return TurbineGroupPeer.getTableMap();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("TurbineGroup:\n");
        str.append("GroupId = ").append(this.getGroupId()).append("\n");
        str.append("Name = ").append(this.getName()).append("\n");
        return str.toString();
    }
}

