/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.services.schedule.JobQueue;
import org.apache.turbine.services.schedule.TurbineSchedulerService;
import org.apache.turbine.util.TurbineException;

public class TurbineNonPersistentSchedulerService
extends TurbineSchedulerService {
    private static Log log = LogFactory.getLog((String)"scheduler");

    @Override
    public void init() throws InitializationException {
        Configuration conf = this.getConfiguration();
        try {
            this.scheduleQueue = new JobQueue();
            this.mainLoop = new TurbineSchedulerService.MainLoop(this);
            List jobProps = conf.getList("scheduler.jobs");
            Vector<JobEntry> jobs = new Vector<JobEntry>();
            if (!jobProps.isEmpty()) {
                for (int i = 0; i < jobProps.size(); ++i) {
                    String jobName = (String)jobProps.get(i);
                    String jobPrefix = "scheduler.job." + jobName;
                    String jobId = conf.getString(jobPrefix + ".ID", null);
                    if (StringUtils.isEmpty((String)jobId)) {
                        throw new Exception("There is an error in the TurbineResources.properties file. \n" + jobPrefix + ".ID is not found.\n");
                    }
                    int sec = conf.getInt(jobPrefix + ".SECOND", -1);
                    int min = conf.getInt(jobPrefix + ".MINUTE", -1);
                    int hr = conf.getInt(jobPrefix + ".HOUR", -1);
                    int wkday = conf.getInt(jobPrefix + ".WEEKDAY", -1);
                    int dayOfMonth = conf.getInt(jobPrefix + ".DAY_OF_MONTH", -1);
                    JobEntry je = new JobEntry(sec, min, hr, wkday, dayOfMonth, jobName);
                    je.setJobId(Integer.parseInt(jobId));
                    jobs.add(je);
                }
            }
            if (jobs != null && jobs.size() > 0) {
                this.scheduleQueue.batchLoad(jobs);
            }
            this.setEnabled(this.getConfiguration().getBoolean("enabled", true));
            this.restart();
            this.setInit(true);
        }
        catch (Exception e) {
            String errorMessage = "Could not initialize the scheduler service";
            log.error((Object)errorMessage, (Throwable)e);
            throw new InitializationException(errorMessage, e);
        }
    }

    @Override
    @Deprecated
    public void init(ServletConfig config) throws InitializationException {
        this.init();
    }

    @Override
    public JobEntry getJob(int oid) throws TurbineException {
        JobEntry je = new JobEntry();
        je.setJobId(oid);
        return this.scheduleQueue.getJob(je);
    }

    @Override
    public void addJob(JobEntry je) throws TurbineException {
        this.updateJob(je);
    }

    @Override
    public void removeJob(JobEntry je) {
        this.scheduleQueue.remove(je);
        this.restart();
    }

    @Override
    public void updateJob(JobEntry je) throws TurbineException {
        try {
            je.calcRunTime();
            this.scheduleQueue.modify(je);
            this.restart();
        }
        catch (Exception e) {
            String errorMessage = "Problem updating Scheduled Job: " + je.getTask();
            log.error((Object)errorMessage, (Throwable)e);
            throw new TurbineException(errorMessage, e);
        }
    }
}

