/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.ldap;

import java.util.Properties;
import org.apache.turbine.services.security.TurbineSecurity;

public class LDAPSecurityConstants {
    public static final String LDAP_ADMIN_USERNAME_KEY = "ldap.admin.username";
    public static final String LDAP_ADMIN_PASSWORD_KEY = "ldap.admin.password";
    public static final String LDAP_HOST_KEY = "ldap.host";
    public static final String LDAP_HOST_DEFAULT = "localhost";
    public static final String LDAP_PORT_KEY = "ldap.port";
    public static final String LDAP_PORT_DEFAULT = "389";
    public static final String LDAP_PROVIDER_KEY = "ldap.provider";
    public static final String LDAP_PROVIDER_DEFAULT = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String LDAP_BASE_SEARCH_KEY = "ldap.basesearch";
    public static final String LDAP_AUTH_KEY = "ldap.security.authentication";
    public static final String LDAP_AUTH_DEFAULT = "simple";
    public static final String LDAP_USER_USERID_KEY = "ldap.user.userid";
    public static final String LDAP_USER_USERID_DEFAULT = "uid";
    public static final String LDAP_USER_USERNAME_KEY = "ldap.user.username";
    public static final String LDAP_USER_USERNAME_DEFAULT = "turbineUserUniqueId";
    public static final String LDAP_USER_FIRSTNAME_KEY = "ldap.user.firstname";
    public static final String LDAP_USER_FIRSTNAME_DEFAULT = "turbineUserFirstName";
    public static final String LDAP_USER_LASTNAME_KEY = "ldap.user.lastname";
    public static final String LDAP_USER_LASTNAME_DEFAULT = "turbineUserLastName";
    public static final String LDAP_USER_EMAIL_KEY = "ldap.user.email";
    public static final String LDAP_USER_EMAIL_DEFAULT = "turbineUserMailAddress";
    public static final String LDAP_USER_PASSWORD_KEY = "ldap.user.password";
    public static final String LDAP_USER_PASSWORD_DEFAULT = "userPassword";

    public static Properties getProperties() {
        return TurbineSecurity.getService().getProperties();
    }

    public static String getProperty(String key) {
        return LDAPSecurityConstants.getProperties().getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return LDAPSecurityConstants.getProperties().getProperty(key, defaultValue);
    }

    public static String getAdminUsername() {
        String str = LDAPSecurityConstants.getProperty(LDAP_ADMIN_USERNAME_KEY);
        str = str.replace('/', '=');
        str = str.replace('%', ',');
        return str;
    }

    public static String getAdminPassword() {
        return LDAPSecurityConstants.getProperty(LDAP_ADMIN_PASSWORD_KEY);
    }

    public static String getLDAPHost() {
        return LDAPSecurityConstants.getProperty(LDAP_HOST_KEY, LDAP_HOST_DEFAULT);
    }

    public static String getLDAPPort() {
        return LDAPSecurityConstants.getProperty(LDAP_PORT_KEY, LDAP_PORT_DEFAULT);
    }

    public static String getLDAPProvider() {
        return LDAPSecurityConstants.getProperty(LDAP_PROVIDER_KEY, LDAP_PROVIDER_DEFAULT);
    }

    public static String getBaseSearch() {
        String str = LDAPSecurityConstants.getProperty(LDAP_BASE_SEARCH_KEY);
        str = str.replace('/', '=');
        str = str.replace('%', ',');
        return str;
    }

    public static String getLDAPAuthentication() {
        return LDAPSecurityConstants.getProperty(LDAP_AUTH_KEY, LDAP_AUTH_DEFAULT);
    }

    public static String getUserIdAttribute() {
        return LDAPSecurityConstants.getProperty(LDAP_USER_USERID_KEY, LDAP_USER_USERID_DEFAULT);
    }

    public static String getNameAttribute() {
        return LDAPSecurityConstants.getProperty(LDAP_USER_USERNAME_KEY, LDAP_USER_USERNAME_DEFAULT);
    }

    public static String getUserNameAttribute() {
        return LDAPSecurityConstants.getNameAttribute();
    }

    public static String getFirstNameAttribute() {
        return LDAPSecurityConstants.getProperty(LDAP_USER_FIRSTNAME_KEY, LDAP_USER_FIRSTNAME_DEFAULT);
    }

    public static String getLastNameAttribute() {
        return LDAPSecurityConstants.getProperty(LDAP_USER_LASTNAME_KEY, LDAP_USER_LASTNAME_DEFAULT);
    }

    public static String getPasswordAttribute() {
        return LDAPSecurityConstants.getProperty(LDAP_USER_PASSWORD_KEY, LDAP_USER_PASSWORD_DEFAULT);
    }

    public static String getEmailAttribute() {
        return LDAPSecurityConstants.getProperty(LDAP_USER_EMAIL_KEY, LDAP_USER_EMAIL_DEFAULT);
    }
}

