/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.pages;

import org.apache.turbine.modules.pages.DefaultPage;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class TemplatePage
extends DefaultPage {
    @Override
    protected void doBuildAfterAction(RunData data) throws Exception {
        if (!data.hasScreen()) {
            String template = data.getTemplateInfo().getScreenTemplate();
            String layoutTemplate = TurbineTemplate.getLayoutTemplateName(template);
            data.getTemplateInfo().setLayoutTemplate(layoutTemplate);
            String screen = TurbineTemplate.getScreenName(template);
            if (screen == null) {
                String errMsg = "Couldn't map Template " + template + " to any Screen class!";
                this.log.error((Object)errMsg);
                throw new TurbineException(errMsg);
            }
            data.setScreen(screen);
        }
    }

    @Override
    protected void doBuildAfterAction(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        this.doBuildAfterAction(data);
    }
}

