/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.interceptor.util;

import java.lang.reflect.Method;
import org.apache.fulcrum.yaafi.interceptor.util.InterceptorToStringBuilder;

public class MethodToStringBuilderImpl
implements InterceptorToStringBuilder {
    public static final int INCLUDE_RETURNTYPE = 1;
    private static int defaultMode = 1;
    private int mode;
    private static final int BUF_SIZE = 512;
    private Method method;

    public MethodToStringBuilderImpl() {
        this.mode = defaultMode;
    }

    public MethodToStringBuilderImpl(Method method) {
        this.method = method;
        this.mode = defaultMode;
    }

    public MethodToStringBuilderImpl(Method method, int mode) {
        this.method = method;
        this.mode = mode;
    }

    @Override
    public void setMaxArgLength(int maxArgLength) {
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public void setTarget(Object target) {
        this.method = (Method)target;
    }

    @Override
    public String toString() {
        try {
            StringBuilder buffer = new StringBuilder(512);
            Class<?> returnType = this.method.getReturnType();
            Class<?> declaringClass = this.method.getDeclaringClass();
            Class<?>[] params = this.method.getParameterTypes();
            if ((this.mode & 1) == 1) {
                buffer.append(returnType.getSimpleName());
                buffer.append(' ');
            }
            buffer.append(declaringClass.getSimpleName());
            buffer.append('.');
            buffer.append(this.method.getName());
            buffer.append('(');
            for (int i = 0; i < params.length; ++i) {
                buffer.append(params[i].getSimpleName());
                if (i >= params.length - 1) continue;
                buffer.append(",");
            }
            buffer.append(")");
            return buffer.toString();
        }
        catch (Throwable t) {
            return "<" + t.getClass().getSimpleName() + ">";
        }
    }
}

