/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.parser;

import java.util.Map;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import net.sf.uadetector.DeviceCategory;
import net.sf.uadetector.OperatingSystem;
import net.sf.uadetector.ReadableDeviceCategory;
import net.sf.uadetector.UserAgent;
import net.sf.uadetector.UserAgentStringParser;
import net.sf.uadetector.UserAgentType;
import net.sf.uadetector.VersionNumber;
import net.sf.uadetector.datastore.DataStore;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.Device;
import net.sf.uadetector.internal.data.domain.DevicePattern;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.internal.data.domain.Robot;

public abstract class AbstractUserAgentStringParser
implements UserAgentStringParser {
    private static final int ZERO_MATCHING_GROUPS = 0;

    private static void examineAsBrowser(UserAgent.Builder builder, Data data) {
        VersionNumber version = VersionNumber.UNKNOWN;
        for (Map.Entry<BrowserPattern, Browser> entry : data.getPatternToBrowserMap().entrySet()) {
            Matcher matcher = entry.getKey().getPattern().matcher(builder.getUserAgentString());
            if (!matcher.find()) continue;
            entry.getValue().copyTo(builder);
            if (matcher.groupCount() > 0) {
                version = VersionNumber.parseVersion(matcher.group(1) != null ? matcher.group(1) : "");
            }
            builder.setVersionNumber(version);
            break;
        }
    }

    private static boolean examineAsRobot(UserAgent.Builder builder, Data data) {
        boolean isRobot = false;
        for (Robot robot : data.getRobots()) {
            if (!robot.getUserAgentString().equals(builder.getUserAgentString())) continue;
            isRobot = true;
            robot.copyTo(builder);
            VersionNumber version = VersionNumber.parseLastVersionNumber(robot.getName());
            builder.setVersionNumber(version);
            break;
        }
        return isRobot;
    }

    private static void examineDeviceCategory(UserAgent.Builder builder, Data data) {
        DeviceCategory category;
        if (UserAgentType.ROBOT == builder.getType()) {
            DeviceCategory category2 = AbstractUserAgentStringParser.findDeviceCategoryByValue(ReadableDeviceCategory.Category.OTHER, data);
            builder.setDeviceCategory(category2);
            return;
        }
        for (Map.Entry<DevicePattern, Device> entry : data.getPatternToDeviceMap().entrySet()) {
            Matcher matcher = entry.getKey().getPattern().matcher(builder.getUserAgentString());
            if (!matcher.find()) continue;
            ReadableDeviceCategory.Category category3 = ReadableDeviceCategory.Category.evaluate(entry.getValue().getName());
            DeviceCategory deviceCategory = AbstractUserAgentStringParser.findDeviceCategoryByValue(category3, data);
            builder.setDeviceCategory(deviceCategory);
            return;
        }
        if (UserAgentType.UNKNOWN == builder.getType()) {
            builder.setDeviceCategory(DeviceCategory.EMPTY);
            return;
        }
        if (UserAgentType.OTHER == builder.getType() || UserAgentType.LIBRARY == builder.getType() || UserAgentType.VALIDATOR == builder.getType() || UserAgentType.USERAGENT_ANONYMIZER == builder.getType()) {
            category = AbstractUserAgentStringParser.findDeviceCategoryByValue(ReadableDeviceCategory.Category.OTHER, data);
            builder.setDeviceCategory(category);
            return;
        }
        if (UserAgentType.MOBILE_BROWSER == builder.getType() || UserAgentType.WAP_BROWSER == builder.getType()) {
            category = AbstractUserAgentStringParser.findDeviceCategoryByValue(ReadableDeviceCategory.Category.SMARTPHONE, data);
            builder.setDeviceCategory(category);
            return;
        }
        category = AbstractUserAgentStringParser.findDeviceCategoryByValue(ReadableDeviceCategory.Category.PERSONAL_COMPUTER, data);
        builder.setDeviceCategory(category);
    }

    private static void examineOperatingSystem(UserAgent.Builder builder, Data data) {
        if (OperatingSystem.EMPTY.equals(builder.getOperatingSystem())) {
            for (Map.Entry<OperatingSystemPattern, net.sf.uadetector.internal.data.domain.OperatingSystem> entry : data.getPatternToOperatingSystemMap().entrySet()) {
                Matcher matcher = entry.getKey().getPattern().matcher(builder.getUserAgentString());
                if (!matcher.find()) continue;
                entry.getValue().copyTo(builder);
                break;
            }
        }
    }

    private static DeviceCategory findDeviceCategoryByValue(@Nonnull ReadableDeviceCategory.Category category, @Nonnull Data data) {
        for (Device device : data.getDevices()) {
            if (category != device.getCategory()) continue;
            return new DeviceCategory(category, device.getIcon(), device.getInfoUrl(), device.getName());
        }
        return DeviceCategory.EMPTY;
    }

    protected abstract DataStore getDataStore();

    @Override
    public String getDataVersion() {
        return this.getDataStore().getData().getVersion();
    }

    @Override
    public UserAgent parse(String userAgent) {
        UserAgent.Builder builder = new UserAgent.Builder(userAgent);
        Data data = this.getDataStore().getData();
        if (!AbstractUserAgentStringParser.examineAsRobot(builder, data)) {
            AbstractUserAgentStringParser.examineAsBrowser(builder, data);
            AbstractUserAgentStringParser.examineOperatingSystem(builder, data);
        }
        AbstractUserAgentStringParser.examineDeviceCategory(builder, data);
        return builder.build();
    }

    @Override
    public void shutdown() {
    }
}

