/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.turbine.modules.ScheduledJobLoader;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.util.TurbineException;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;

public class JobEntryQuartz
implements JobEntry,
Job {
    private int jobId;
    private Trigger jobTrigger;
    private JobDetail jobDetail;
    private String task;
    private boolean isnew = true;
    private AtomicBoolean active = new AtomicBoolean(false);
    public static final String DEFAULT_JOB_GROUP_NAME = "TURBINE";

    public JobEntryQuartz() {
    }

    public JobEntryQuartz(Trigger jobTrigger) {
        this(jobTrigger, JobBuilder.newJob(JobEntryQuartz.class).withIdentity(jobTrigger.getJobKey().getName(), DEFAULT_JOB_GROUP_NAME).build());
    }

    public JobEntryQuartz(Trigger jobTrigger, JobDetail jobDetail) {
        this();
        this.setTask(jobTrigger.getJobKey().getName());
        this.jobTrigger = jobTrigger;
        this.jobDetail = jobDetail;
    }

    @Override
    public boolean isNew() {
        boolean _isnew = this.isnew;
        this.isnew = false;
        return _isnew;
    }

    @Override
    public int getJobId() {
        return this.jobId;
    }

    @Override
    public void setJobId(int v) {
        this.jobId = v;
    }

    @Override
    public String getTask() {
        return this.task;
    }

    @Override
    public void setTask(String v) {
        this.task = v;
    }

    public Trigger getJobTrigger() {
        return this.jobTrigger;
    }

    public void setJobTrigger(Trigger jobTrigger) {
        this.jobTrigger = jobTrigger;
    }

    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    @Override
    public int compareTo(JobEntry o) {
        return this.jobTrigger.compareTo(((JobEntryQuartz)o).getJobTrigger());
    }

    @Override
    public void setActive(boolean isActive) {
        this.active.set(isActive);
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }

    @Override
    public long getNextRuntime() {
        return this.getNextRunDate().getTime();
    }

    @Override
    public Date getNextRunDate() {
        return this.jobTrigger.getNextFireTime();
    }

    @Override
    public String getNextRunAsString() {
        return this.getNextRunDate().toString();
    }

    @Override
    public void calcRunTime() throws TurbineException {
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (!this.active.compareAndSet(false, true)) {
            return;
        }
        try {
            String task = this.getTask();
            if (StringUtils.isEmpty((CharSequence)task)) {
                task = context.getJobDetail().getKey().getName();
            }
            ScheduledJobLoader.getInstance().exec(this, task);
        }
        catch (Exception e) {
            throw new JobExecutionException("Error executing scheduled job #" + this.getJobId() + ", task: " + this.getTask(), (Throwable)e);
        }
        finally {
            this.active.compareAndSet(true, false);
        }
    }
}

