/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCacheMonitor;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPCacheFactory;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.apache.commons.jcs3.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceNonLocal;

public class LateralCacheMonitor
extends AbstractAuxiliaryCacheMonitor {
    private final ConcurrentHashMap<String, LateralCacheNoWait<?, ?>> caches;
    private final LateralTCPCacheFactory factory;

    protected static void forceShortIdlePeriod(long idlePeriod) {
        LateralCacheMonitor.idlePeriod = idlePeriod;
    }

    public LateralCacheMonitor(LateralTCPCacheFactory factory) {
        super("JCS-LateralCacheMonitor");
        this.factory = factory;
        this.caches = new ConcurrentHashMap();
        LateralCacheMonitor.setIdlePeriod(20000L);
    }

    public void addCache(LateralCacheNoWait<?, ?> cache) {
        this.caches.put(cache.getCacheName(), cache);
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    @Override
    public void dispose() {
        this.caches.clear();
    }

    @Override
    public void doWork() {
        this.log.info("Number of caches to monitor = " + this.caches.size());
        for (Map.Entry<String, LateralCacheNoWait<?, ?>> entry : this.caches.entrySet()) {
            String cacheName = entry.getKey();
            LateralCacheNoWait<?, ?> c = entry.getValue();
            if (c.getStatus() != CacheStatus.ERROR) continue;
            this.log.info("Found LateralCacheNoWait in error, " + cacheName);
            ITCPLateralCacheAttributes lca = (ITCPLateralCacheAttributes)c.getAuxiliaryCacheAttributes();
            ICacheServiceNonLocal cacheService = this.factory.getCSNLInstance(lca);
            if (cacheService instanceof ZombieCacheServiceNonLocal) continue;
            c.fixCache(cacheService);
        }
    }
}

