/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.pipeline;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.Valve;
import org.apache.turbine.pipeline.ValveContext;
import org.apache.turbine.util.HttpUtils;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class DetermineActionValve
implements Valve {
    private static final Logger log = LogManager.getLogger(DetermineActionValve.class);

    @Override
    public void invoke(PipelineData pipelineData, ValveContext context) throws IOException, TurbineException {
        RunData data = pipelineData.getRunData();
        if (!data.hasAction()) {
            String action = data.getParameters().getString("action");
            if (action != null) {
                if (HttpUtils.keyRequiresClean(action)) {
                    String testAction = HttpUtils.getCleanedKey(action);
                    String message = "action has invalid characters. ";
                    log.warn("{}. Debug action key: {}.", (Object)message, (Object)testAction);
                    throw new TurbineException(message);
                }
                data.setAction(action);
                log.debug("Set action from request parameter");
            } else {
                log.debug("No action");
            }
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = data::getAction;
        log.debug("Action is now: {}", supplierArray);
        context.invokeNext(pipelineData);
    }
}

