/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.learner.trabal.AnnotationErrorType;
import org.apache.uima.ruta.textruler.learner.trabal.Condition;
import org.apache.uima.ruta.textruler.learner.trabal.ConditionType;
import org.apache.uima.ruta.textruler.learner.trabal.ShiftingRule;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalAnnotation;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalLearner;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRule;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRuleItem;

public class ShiftAllRule
extends ShiftingRule {
    private TrabalRuleItem errorBoundaryItem;

    public ShiftAllRule(TrabalLearner parentAlgorithm, TextRulerTarget target, TrabalAnnotation annotation, TrabalAnnotation targetAnnotation, AnnotationErrorType errorType) {
        super(parentAlgorithm, target, annotation, targetAnnotation, errorType);
    }

    public ShiftAllRule(ShiftAllRule copyFrom) {
        super(copyFrom);
        this.errorBoundaryItem = copyFrom.errorBoundaryItem;
    }

    @Override
    public void compileRuleString() {
        String conditions;
        this.ruleString = "";
        boolean shiftToLeft = this.errorType == AnnotationErrorType.SHIFTING_LEFT;
        boolean frontItemInBorders = this.frontBoundaryItem.getAnnotation().getBegin() == this.targetAnnotation.getBegin();
        boolean rearItemInBorders = this.rearBoundaryItem.getAnnotation().getEnd() == this.targetAnnotation.getEnd();
        String before = this.parseConditions(ConditionType.BEFORE);
        if (before.length() > 0) {
            before = "{" + before + "}";
        }
        if ((conditions = this.parseConditions(this.conditionTypes)).length() > 0) {
            conditions = conditions + " ";
        }
        String mark = ((TrabalLearner)this.algorithm).getEnableFeatures() ? "-> CREATE(" + this.targetAnnotation.getType().getShortName() + this.parseFeatures() + ")" : "-> MARK(" + this.targetAnnotation.getType().getShortName() + ")";
        String action = "{" + conditions + mark + "}";
        if (this.errorBoundaryItem == null) {
            this.compileWithoutErrorRuleItem(frontItemInBorders, rearItemInBorders, before, action);
        } else {
            String after = this.parseConditions(ConditionType.AFTER);
            if (after.length() > 0) {
                after = "{" + after + "}";
            }
            String unmark = this.errorBoundaryItem + (frontItemInBorders ? "" : " ANY") + "{STARTSWITH(" + this.annotation.getType().getShortName() + ") -> UNMARK(" + this.annotation.getType().getShortName() + ", true)}";
            if (shiftToLeft) {
                this.compileShiftToLeft(frontItemInBorders, rearItemInBorders, before, after, action, unmark);
            } else {
                this.compileShiftToRight(frontItemInBorders, rearItemInBorders, before, after, action, unmark);
            }
        }
        this.setNeedsCompile(false);
    }

    private void compileShiftToLeft(boolean frontItemInBorders, boolean rearItemInBorders, String before, String after, String action, String unmark) {
        this.ruleString = frontItemInBorders ? this.ruleString + "(" + this.frontBoundaryItem + after + " " : this.ruleString + this.frontBoundaryItem + after + " (";
        this.ruleString = this.ruleString + "ANY*{-PARTOF(" + this.errorBoundaryItem + ")} " + unmark + " ANY*{-PARTOF(" + this.rearBoundaryItem + ")}";
        this.ruleString = rearItemInBorders ? this.ruleString + " " + this.rearBoundaryItem + before + ")" + action + ";" : this.ruleString + ")" + action + " " + this.rearBoundaryItem + before + ";";
    }

    private void compileShiftToRight(boolean frontItemInBorders, boolean rearItemInBorders, String before, String after, String action, String unmark) {
        this.ruleString = this.ruleString + unmark + " ANY*{-PARTOF(" + this.frontBoundaryItem + ")} ";
        this.ruleString = frontItemInBorders ? this.ruleString + "(" + this.frontBoundaryItem + after + " " : this.ruleString + this.frontBoundaryItem + after + " (";
        this.ruleString = this.ruleString + "ANY*{-PARTOF(" + this.rearBoundaryItem + ")}";
        this.ruleString = rearItemInBorders ? this.ruleString + " " + this.rearBoundaryItem + before + ")" + action + ";" : this.ruleString + ")" + action + " " + this.rearBoundaryItem + before + ";";
    }

    private void compileWithoutErrorRuleItem(boolean frontItemInBorders, boolean rearItemInBorders, String before, String action) {
        String after = this.parseConditions(ConditionType.AFTER);
        if (after.length() > 0) {
            after = ", " + after;
        }
        String unmark = "{STARTSWITH(" + this.annotation.getType().getShortName() + ")" + after + " -> UNMARK(" + this.annotation.getType().getShortName() + ", true)}";
        this.ruleString = frontItemInBorders ? this.ruleString + "(" + this.frontBoundaryItem + unmark + " " : this.ruleString + this.frontBoundaryItem + unmark + " (";
        this.ruleString = this.ruleString + "ANY*{-PARTOF(" + this.rearBoundaryItem + ")}";
        this.ruleString = rearItemInBorders ? this.ruleString + " " + this.rearBoundaryItem + before + ")" + action + ";" : this.ruleString + ")" + action + " " + this.rearBoundaryItem + before + ";";
    }

    @Override
    public boolean contains(TrabalAnnotation target) {
        if (target != null) {
            if (this.annotation.getType().getShortName().equals(target.getType().getShortName())) {
                return true;
            }
            if (this.targetAnnotation.getType().getShortName().equals(target.getType().getShortName())) {
                return true;
            }
            if (this.frontBoundaryItem != null && this.frontBoundaryItem.getAnnotation().equals(target)) {
                return true;
            }
            if (this.errorBoundaryItem != null && this.errorBoundaryItem.getAnnotation().equals(target)) {
                return true;
            }
            if (this.rearBoundaryItem != null && this.rearBoundaryItem.getAnnotation().equals(target)) {
                return true;
            }
            for (Condition each : this.getConditions()) {
                if (!each.getItem().getAnnotation().getType().getShortName().equals(target.getType().getShortName())) continue;
                return true;
            }
        }
        return false;
    }

    public void setErrorBoundaryItem(TrabalRuleItem errorBoundaryItem) {
        this.errorBoundaryItem = errorBoundaryItem;
    }

    @Override
    public TrabalRule copy() {
        return new ShiftAllRule(this);
    }
}

