/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.ui.views.evalDataTable;

public class TypeEvalData
implements Comparable {
    private String scriptName;
    private int truePositives;
    private int falsePositives;
    private int falseNegatives;
    private double precision;
    private double recall;
    private double FOne;

    public TypeEvalData(String scriptName, int truePositives, int falsePositives, int falseNegatives) {
        this.scriptName = scriptName;
        this.truePositives = truePositives;
        this.falsePositives = falsePositives;
        this.falseNegatives = falseNegatives;
    }

    public String getTypeName() {
        return this.scriptName;
    }

    public int getTruePositives() {
        return this.truePositives;
    }

    public int getFalsePositives() {
        return this.falsePositives;
    }

    public int getFalseNegatives() {
        return this.falseNegatives;
    }

    public void setFalseNegatives(int falseNegatives) {
        this.falseNegatives = falseNegatives;
    }

    public void setFalsePositives(int falsePositives) {
        this.falsePositives = falsePositives;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public void setTruePositives(int truePositives) {
        this.truePositives = truePositives;
    }

    public double getPrecision() {
        return this.precision;
    }

    public double getRecall() {
        return this.recall;
    }

    public double getFOne() {
        return this.FOne;
    }

    public int compareTo(Object o) {
        String name;
        if (o instanceof TypeEvalData && this.scriptName.equals(name = ((TypeEvalData)o).getTypeName())) {
            return 1;
        }
        return 0;
    }

    public void calcFOne() {
        double tp = this.truePositives;
        double fp = this.falsePositives;
        double fn = this.falseNegatives;
        if (this.truePositives == 0) {
            this.precision = 0.0;
            this.recall = 0.0;
            this.FOne = 0.0;
        } else {
            this.precision = tp / (tp + fp);
            this.recall = tp / (tp + fn);
            this.FOne = 2.0 * (this.precision * this.recall) / (this.precision + this.recall);
            this.precision *= 1000.0;
            this.precision = Math.round(this.precision);
            this.precision /= 1000.0;
            this.recall *= 1000.0;
            this.recall = Math.round(this.recall);
            this.recall /= 1000.0;
            this.FOne *= 1000.0;
            this.FOne = Math.round(this.FOne);
            this.FOne /= 1000.0;
        }
    }
}

