/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.block;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.block.BlockApply;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.AnnotationTypeExpression;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.MatchReference;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.rule.AbstractRule;
import org.apache.uima.ruta.rule.AbstractRuleMatch;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.RutaRule;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ForEachBlock
extends RutaBlock {
    private boolean anchorsSet = false;
    private IBooleanExpression direction;

    public ForEachBlock(String varName, IBooleanExpression direction, RutaRule rule, List<RutaStatement> elements, RutaBlock parent, String defaultNamespace) {
        super(varName, rule, elements, parent, defaultNamespace, parent != null ? parent.getContext() : null);
        this.direction = direction;
    }

    @Override
    public ScriptApply apply(RutaStream stream, InferenceCrowd crowd) {
        BlockApply result = new BlockApply(this);
        this.getEnvironment().ensureMaterializedInitialValues(new MatchContext(this), stream);
        crowd.beginVisit(this, result);
        this.setRuleElementAnchor();
        boolean leftToRight = true;
        if (this.direction != null) {
            leftToRight = this.direction.getBooleanValue(new MatchContext(this.getParent()), stream);
        }
        RuleApply apply = this.rule.apply(stream, crowd, true);
        List<AbstractRuleMatch<? extends AbstractRule>> list = apply.getList();
        if (!leftToRight) {
            Collections.reverse(list);
        }
        for (AbstractRuleMatch<? extends AbstractRule> eachMatch : list) {
            List<AnnotationFS> matchedAnnotations;
            if (!eachMatch.matched() || (matchedAnnotations = ((RuleMatch)eachMatch).getMatchedAnnotations(null, null)) == null || matchedAnnotations.isEmpty()) continue;
            for (AnnotationFS eachMatchedAnnotation : matchedAnnotations) {
                this.environment.addVariable(this.name, "ANNOTATION");
                this.environment.setVariableValue(this.name, eachMatchedAnnotation);
                for (RutaStatement element : this.elements) {
                    if (element == null) continue;
                    element.apply(stream, crowd);
                }
            }
        }
        crowd.endVisit(this, result);
        return result;
    }

    private void setRuleElementAnchor() {
        if (this.anchorsSet) {
            return;
        }
        for (RutaStatement eachElement : this.elements) {
            RuleElement ruleElement;
            boolean set;
            if (!(eachElement instanceof RutaRule)) continue;
            RutaRule eachRule = (RutaRule)eachElement;
            List<RuleElement> ruleElements = eachRule.getRuleElements();
            Iterator<RuleElement> iterator = ruleElements.iterator();
            while (iterator.hasNext() && !(set = this.setRuleElementAnchorRecursively(ruleElement = iterator.next()))) {
            }
        }
        this.anchorsSet = true;
    }

    private boolean setRuleElementAnchorRecursively(RuleElement ruleElement) {
        if (ruleElement instanceof RutaRuleElement) {
            RutaMatcher matcher = ((RutaRuleElement)ruleElement).getMatcher();
            if (matcher == null) {
                return false;
            }
            IRutaExpression expression = matcher.getExpression();
            if (expression instanceof AnnotationTypeExpression) {
                MatchReference reference = ((AnnotationTypeExpression)expression).getReference();
                String match = reference.getMatch();
                boolean equals = StringUtils.equals((CharSequence)this.name, (CharSequence)match);
                if (equals) {
                    ruleElement.setStartAnchor(equals);
                }
                return equals;
            }
        } else if (ruleElement instanceof ComposedRuleElement) {
            List<RuleElement> ruleElements = ((ComposedRuleElement)ruleElement).getRuleElements();
            for (RuleElement eachInnerRuleElement : ruleElements) {
                boolean set = this.setRuleElementAnchorRecursively(eachInnerRuleElement);
                if (!set) continue;
                return set;
            }
        }
        return false;
    }

    public String toString() {
        String ruleString = this.rule == null ? "Document" : this.rule.toString();
        int elementSize = this.elements == null ? 0 : this.elements.size();
        return "FOREACH(" + this.name + ") " + ruleString + " containing " + elementSize + " Elements";
    }

    public IBooleanExpression getDirection() {
        return this.direction;
    }
}

