/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.activemq;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.uima.aae.message.MessageWrapper;
import org.springframework.jms.listener.SessionAwareMessageListener;

public class PriorityMessageHandler
implements SessionAwareMessageListener {
    private PriorityBlockingQueue<MessageWrapper> queue = new PriorityBlockingQueue();
    private Semaphore targetedListenerSemaphore = null;
    private Semaphore processListenerSemaphore = null;

    public PriorityMessageHandler(int scaleout) {
        this.processListenerSemaphore = new Semaphore(scaleout);
        this.targetedListenerSemaphore = new Semaphore(1);
    }

    public BlockingQueue<MessageWrapper> getQueue() {
        return this.queue;
    }

    public void onMessage(Message message, Session session) throws JMSException {
        Semaphore semaphore = null;
        semaphore = "TargetMessage".equals(message.getJMSType()) ? this.targetedListenerSemaphore : this.processListenerSemaphore;
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            System.out.println("Semaphore Interrupted ");
        }
        MessageWrapper m = new MessageWrapper((Object)message, (Object)session, semaphore, message.getJMSPriority());
        this.queue.add(m);
    }
}

