/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.client;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQTempDestination;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.aae.AsynchAECasManager_impl;
import org.apache.uima.aae.UimaASApplicationEvent;
import org.apache.uima.aae.UimaASApplicationExitEvent;
import org.apache.uima.aae.UimaAsVersion;
import org.apache.uima.aae.VersionCompatibilityChecker;
import org.apache.uima.aae.client.UimaASStatusCallbackListener;
import org.apache.uima.aae.client.UimaAsBaseCallbackListener;
import org.apache.uima.aae.client.UimaAsynchronousEngine;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.ControllerCallbackListener;
import org.apache.uima.aae.controller.ControllerLifecycle;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.UimacppServiceController;
import org.apache.uima.aae.error.UimaASMetaRequestTimeout;
import org.apache.uima.aae.jmx.JmxManager;
import org.apache.uima.adapter.jms.ConnectionValidator;
import org.apache.uima.adapter.jms.activemq.SpringContainerDeployer;
import org.apache.uima.adapter.jms.activemq.UimaEEAdminSpringContext;
import org.apache.uima.adapter.jms.client.ActiveMQConnectionValidator;
import org.apache.uima.adapter.jms.client.ActiveMQMessageSender;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngineCommon_impl;
import org.apache.uima.adapter.jms.client.ClientServiceDelegate;
import org.apache.uima.adapter.jms.client.InvalidContainerException;
import org.apache.uima.adapter.jms.client.MessageSender;
import org.apache.uima.adapter.jms.message.PendingMessage;
import org.apache.uima.adapter.jms.service.Dd2spring;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.internal.util.UUIDGenerator;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class BaseUIMAAsynchronousEngine_impl
extends BaseUIMAAsynchronousEngineCommon_impl
implements UimaAsynchronousEngine,
MessageListener,
ControllerCallbackListener,
ApplicationListener<ApplicationEvent> {
    private static final Class CLASS_NAME = BaseUIMAAsynchronousEngine_impl.class;
    private ActiveMQMessageSender sender = null;
    private MessageProducer producer;
    private Session session = null;
    private Session consumerSession = null;
    private volatile boolean serviceInitializationException;
    private volatile boolean serviceInitializationCompleted;
    private Semaphore serviceSemaphore = new Semaphore(1);
    private Queue consumerDestination = null;
    private Session producerSession = null;
    private JmxManager jmxManager = null;
    private String applicationName = "UimaASClient";
    private String endpoint;
    protected static Semaphore sharedConnectionSemaphore = new Semaphore(1);
    protected static Object connectionMux = new Object();
    protected InitialContext jndiContext;
    private ObjectName clientJmxObjectName = null;
    private String amqUser = null;
    private String amqPassword = null;
    protected static Lock globalLock = new ReentrantLock();
    protected volatile boolean stopped = false;

    public BaseUIMAAsynchronousEngine_impl() {
        UIMAFramework.getLogger((Class)CLASS_NAME).log(Level.INFO, "UIMA Version " + UIMAFramework.getVersionString() + " UIMA-AS Version " + UimaAsVersion.getVersionString());
    }

    protected TextMessage createTextMessage() throws ResourceInitializationException {
        return new ActiveMQTextMessage();
    }

    protected BytesMessage createBytesMessage() throws ResourceInitializationException {
        return new ActiveMQBytesMessage();
    }

    protected void cleanup() throws Exception {
    }

    public String getEndPointName() throws ResourceProcessException {
        try {
            return this.clientSideJmxStats.getEndpointName();
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    protected void setMetaRequestMessage(Message msg) throws Exception {
        msg.setStringProperty("MessageFrom", this.consumerDestination.getQueueName());
        msg.setStringProperty("ServerURI", this.brokerURI);
        msg.setIntProperty("MessageType", 3000);
        msg.setIntProperty("Command", 2001);
        msg.setJMSReplyTo((Destination)this.consumerDestination);
        if (msg instanceof TextMessage) {
            ((ActiveMQTextMessage)msg).setText("");
        }
    }

    protected void setCASMessage(String aCasReferenceId, CAS aCAS, Message msg) throws ResourceProcessException {
        try {
            this.setCommonProperties(aCasReferenceId, msg, SerialFormat.XMI);
            ((TextMessage)msg).setText(this.serializeCAS(aCAS));
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    protected void setCASMessage(String aCasReferenceId, String aSerializedCAS, Message msg) throws ResourceProcessException {
        try {
            this.setCommonProperties(aCasReferenceId, msg, SerialFormat.XMI);
            ((TextMessage)msg).setText(aSerializedCAS);
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    protected void setCASMessage(String aCasReferenceId, byte[] aSerializedCAS, Message msg) throws ResourceProcessException {
        try {
            this.setCommonProperties(aCasReferenceId, msg, SerialFormat.BINARY);
            ((BytesMessage)msg).writeBytes(aSerializedCAS);
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    protected void setCommonProperties(String aCasReferenceId, Message msg, SerialFormat serialFormat) throws ResourceProcessException {
        try {
            msg.setStringProperty("MessageFrom", this.consumerDestination.getQueueName());
            msg.setStringProperty("ServerURI", this.brokerURI);
            msg.setIntProperty("MessageType", 3000);
            msg.setIntProperty("Command", 2000);
            msg.setStringProperty("CasReference", aCasReferenceId);
            msg.setIntProperty("Payload", serialFormat == SerialFormat.XMI ? 1000 : 1006);
            msg.setBooleanProperty("AcceptsDeltaCas", true);
            msg.setJMSReplyTo((Destination)this.consumerDestination);
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConnection() {
        block26: {
            BaseUIMAAsynchronousEngineCommon_impl.SharedConnection sharedConnection;
            if (this.brokerURI != null && (sharedConnection = this.lookupConnection(this.brokerURI)) != null) {
                try {
                    String msg;
                    String msg2;
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                        msg2 = ":::::::::::::::: " + Thread.currentThread().getId() + " stopConnection() - acquiring semaphore";
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "stopConnection", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg2});
                    }
                    sharedConnection.getSemaphore().acquire();
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                        msg2 = ":::::::::::::::: " + Thread.currentThread().getId() + " stopConnection() - acquired semaphore";
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "stopConnection", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg2});
                    }
                    sharedConnection.unregisterClient((BaseUIMAAsynchronousEngineCommon_impl)this);
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                        msg2 = ":::::::::::::::: " + Thread.currentThread().getId() + " stopConnection() - 1";
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "stopConnection", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg2});
                    }
                    ActiveMQConnection amqc = (ActiveMQConnection)sharedConnection.getConnection();
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                        msg = ":::::::::::::::: " + Thread.currentThread().getId() + " stopConnection() - 2";
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "stopConnection", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
                    }
                    if (this.initialized) {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                            msg = ":::::::::::::::: " + Thread.currentThread().getId() + " stopConnection() - 3";
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "stopConnection", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
                        }
                        try {
                            if (amqc != null) {
                                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                                    msg = "................ Closing Client Connection client ID:" + amqc.getConnectionInfo().getClientId() + " Client Count:" + sharedConnection.getClientCount();
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "stopConnection", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
                                }
                            } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                                msg = ":::::::::::::::: " + Thread.currentThread().getId() + " stopConnection() - 5";
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "stopConnection", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
                            }
                            if (amqc != null && amqc.isStarted() && ((ActiveMQSession)this.consumerSession).isRunning()) {
                                this.consumerSession.close();
                                ((ActiveMQMessageConsumer)this.consumer).stop();
                                this.consumer.close();
                                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                                    msg = ":::::::::::::::: " + Thread.currentThread().getId() + " stopConnection() - 6";
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "stopConnection", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
                                }
                                if (sharedConnection.getClientCount() <= 1) {
                                    sharedConnection.destroy();
                                    amqc.close();
                                }
                            } else if (sharedConnection.getClientCount() <= 1) {
                                sharedConnection.destroy();
                                amqc.close();
                            }
                        }
                        catch (Exception exx) {
                            exx.printStackTrace();
                        }
                    }
                    if (amqc == null || amqc.isClosed() || amqc.isClosing() || this.consumerDestination == null || !(this.consumerDestination instanceof ActiveMQTempDestination)) break block26;
                    try {
                        if (!amqc.isClosed() && !amqc.isTransportFailed()) {
                            amqc.deleteTempDestination((ActiveMQTempDestination)this.consumerDestination);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    sharedConnection.destroy();
                    if (sharedConnection != null) {
                        sharedConnection.getSemaphore().release();
                    }
                }
            }
        }
    }

    public void stop() {
        try {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "stop", "jms_adapter_messages", "UIMAJMS_stopping_as_client_INFO");
            }
            this.stopConnection();
            super.doStop();
            if (!this.running) {
                return;
            }
            this.running = false;
            if (this.serviceDelegate != null) {
                this.serviceDelegate.cleanup();
            }
            if (this.sender != null) {
                this.sender.doStop();
            }
            try {
                this.undeploy();
                this.clientCache.clear();
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "stop", "jms_adapter_messages", "UIMAJMS_undeployed_containers__INFO");
                }
                if (this.jmxManager != null) {
                    this.jmxManager.unregisterMBean(this.clientJmxObjectName);
                    this.jmxManager.destroy();
                }
            }
            catch (Exception e) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stop", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setCPCMessage(Message msg) throws Exception {
        msg.setStringProperty("MessageFrom", this.consumerDestination.getQueueName());
        msg.setStringProperty("ServerURI", this.brokerURI);
        msg.setIntProperty("MessageType", 3000);
        msg.setIntProperty("Command", 2002);
        msg.setIntProperty("Payload", 1005);
        msg.setBooleanProperty("RemoveEndpoint", true);
        msg.setJMSReplyTo((Destination)this.consumerDestination);
        if (msg instanceof TextMessage) {
            ((TextMessage)msg).setText("");
        }
    }

    protected void setFreeCasMessage(Message msg, String aCasReferenceId, String selector) throws Exception {
        msg.setIntProperty("Payload", 1005);
        msg.setStringProperty("CasReference", aCasReferenceId);
        msg.setIntProperty("MessageType", 3000);
        msg.setIntProperty("Command", 2005);
        msg.setStringProperty("ServerURI", this.brokerURI);
        msg.setJMSReplyTo((Destination)this.consumerDestination);
        if (selector != null) {
            msg.setStringProperty("TargetServiceId", selector);
        }
        if (msg instanceof TextMessage) {
            ((TextMessage)msg).setText("");
        }
    }

    protected void setStopMessage(Message msg, String aCasReferenceId) throws Exception {
        msg.setIntProperty("Payload", 1005);
        msg.setStringProperty("CasReference", aCasReferenceId);
        msg.setIntProperty("MessageType", 3000);
        msg.setIntProperty("Command", 2006);
        msg.setStringProperty("ServerURI", this.brokerURI);
        msg.setJMSReplyTo((Destination)this.consumerDestination);
        if (msg instanceof TextMessage) {
            ((TextMessage)msg).setText("");
        }
    }

    private boolean connectionClosedOrInvalid() {
        BaseUIMAAsynchronousEngineCommon_impl.SharedConnection sharedConnection = this.lookupConnection(this.brokerURI);
        return sharedConnection == null || sharedConnection.getConnection() == null || ((ActiveMQConnection)sharedConnection.getConnection()).isClosed() || ((ActiveMQConnection)sharedConnection.getConnection()).isClosing() || ((ActiveMQConnection)sharedConnection.getConnection()).isTransportFailed();
    }

    private BaseUIMAAsynchronousEngineCommon_impl.SharedConnection createAndInitializeAMQConnection(Semaphore semaphore, String aBrokerURI) throws Exception {
        if (this.stopped) {
            return null;
        }
        ActiveMQConnectionValidator connectionValidator = new ActiveMQConnectionValidator();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(aBrokerURI);
        connectionFactory.setTrustAllPackages(true);
        connectionFactory.setUserName(this.amqUser);
        connectionFactory.setPassword(this.amqPassword);
        BaseUIMAAsynchronousEngineCommon_impl.SharedConnection sharedConnection = (BaseUIMAAsynchronousEngineCommon_impl.SharedConnection)sharedConnections.get(aBrokerURI);
        sharedConnection.setConnectionFactory((ConnectionFactory)connectionFactory);
        sharedConnection.setConnectionValidator((ConnectionValidator)connectionValidator);
        sharedConnection.create();
        this.addPrefetch((ActiveMQConnection)sharedConnection.getConnection());
        ((ActiveMQConnection)sharedConnection.getConnection()).setExceptionListener((ExceptionListener)new ClientExceptionListener());
        sharedConnection.start();
        sharedConnections.put(aBrokerURI, sharedConnection);
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "createAndInitializeAMQConnection", "jms_adapter_messages", "UIMAJMS_client_connection_setup_INFO", new Object[]{aBrokerURI});
        }
        return sharedConnection;
    }

    protected BaseUIMAAsynchronousEngineCommon_impl.SharedConnection createSharedConnection(String aBrokerURI) throws Exception {
        Semaphore perBrokerSemaphore;
        BaseUIMAAsynchronousEngineCommon_impl.SharedConnection sharedConnection;
        try {
            sharedConnectionSemaphore.acquire();
            sharedConnection = (BaseUIMAAsynchronousEngineCommon_impl.SharedConnection)sharedConnections.get(aBrokerURI);
            if (sharedConnection == null) {
                perBrokerSemaphore = new Semaphore(1);
                sharedConnection = new BaseUIMAAsynchronousEngineCommon_impl.SharedConnection(null, aBrokerURI);
                sharedConnection.setSemaphore(perBrokerSemaphore);
                sharedConnections.put(aBrokerURI, sharedConnection);
            } else {
                perBrokerSemaphore = sharedConnection.getSemaphore();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            sharedConnectionSemaphore.release();
        }
        if (!perBrokerSemaphore.tryAcquire(2L, TimeUnit.SECONDS)) {
            throw new TimeoutException("UIMA-AS Client Timed Out Waiting to Acquire Broker Semaphore (2 Seconds) - Broker:" + aBrokerURI);
        }
        try {
            if (this.connectionClosedOrInvalid()) {
                sharedConnection = this.createAndInitializeAMQConnection(perBrokerSemaphore, aBrokerURI);
            }
            this.initializeProducer(this.brokerURI, this.endpoint, sharedConnection.getConnection());
            this.initializeConsumer(this.brokerURI, sharedConnection.getConnection());
            if (sharedConnection != null) {
                sharedConnection.registerClient((BaseUIMAAsynchronousEngineCommon_impl)this);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            perBrokerSemaphore.release();
        }
        return sharedConnection;
    }

    private void addPrefetch(ActiveMQConnection aConnection) {
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(5);
        aConnection.setPrefetchPolicy(prefetchPolicy);
    }

    protected BaseUIMAAsynchronousEngineCommon_impl.SharedConnection validateConnection(String aBrokerURI) throws Exception {
        return this.createSharedConnection(aBrokerURI);
    }

    protected Session getSession(String aBrokerURI) throws Exception {
        BaseUIMAAsynchronousEngineCommon_impl.SharedConnection sharedConnection = this.validateConnection(aBrokerURI);
        return this.getSession(sharedConnection.getConnection());
    }

    protected Session getSession(Connection aConnection) throws Exception {
        this.session = aConnection.createSession(false, 1);
        return this.session;
    }

    protected MessageProducer lookupProducerForEndpoint(Endpoint anEndpoint) throws Exception {
        if (this.lookupConnection(this.brokerURI) == null || this.producerSession == null) {
            throw new ResourceInitializationException();
        }
        Queue dest = this.producerSession.createQueue(anEndpoint.getEndpoint());
        return this.producerSession.createProducer((Destination)dest);
    }

    protected void initializeProducer(String aBrokerURI, String aQueueName) throws Exception {
        BaseUIMAAsynchronousEngineCommon_impl.SharedConnection sharedConnection = this.createSharedConnection(aBrokerURI);
        this.initializeProducer(aBrokerURI, aQueueName, sharedConnection.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeProducer(String aBrokerURI, String aQueueName, Connection aConnection) throws Exception {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "initializeProducer", "jms_adapter_messages", "UIMAJMS_init_jms_producer_INFO", new Object[]{aBrokerURI, aQueueName});
        }
        this.brokerURI = aBrokerURI;
        this.sender = new ActiveMQMessageSender(aConnection, aQueueName, this);
        this.producerInitialized = false;
        Thread t = new Thread((Runnable)((Object)this.sender));
        t.start();
        try {
            this.producerSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.producerSemaphore.release();
        }
        if (this.sender.failed()) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "initializeProducer", "jms_adapter_messages", "UIMAJMS_worker_thread_failed_to_initialize__WARNING", new Object[]{this.sender.getReasonForFailure()});
            }
            this.stop();
            return;
        }
    }

    protected void initializeConsumer(String aBrokerURI) throws Exception {
        BaseUIMAAsynchronousEngineCommon_impl.SharedConnection sharedConnection = this.createSharedConnection(aBrokerURI);
        this.initializeConsumer(aBrokerURI, sharedConnection.getConnection());
    }

    protected void initializeConsumer(String aBrokerURI, Connection connection) throws Exception {
        if (this.consumerSession != null) {
            try {
                this.consumer.close();
                this.consumerSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.consumerSession = this.getSession(connection);
        this.consumerDestination = this.consumerSession.createTemporaryQueue();
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "initializeConsumer", "jms_adapter_messages", "UIMAJMS_init_jms_consumer_INFO", new Object[]{aBrokerURI, this.consumerDestination.getQueueName()});
        }
        this.consumer = this.consumerSession.createConsumer((Destination)this.consumerDestination);
        this.consumer.setMessageListener((MessageListener)this);
    }

    private String replacePlaceholder(String aPlaceholder) throws ResourceInitializationException {
        int startPos = aPlaceholder.indexOf("${");
        if (startPos < 0) {
            return aPlaceholder;
        }
        int endPos = aPlaceholder.indexOf("}", startPos);
        if (endPos < 0) {
            return aPlaceholder;
        }
        String placeholder = aPlaceholder.substring(startPos + 2, endPos);
        String url = System.getProperty(placeholder);
        if (url == null) {
            throw new ResourceInitializationException((Throwable)new Exception("UIMA AS Client Initialization Exception. Value for placeholder:" + placeholder + " is not defined in the system properties."));
        }
        return aPlaceholder.substring(0, startPos) + url + aPlaceholder.substring(endPos + 1);
    }

    public synchronized void initialize(Map anApplicationContext) throws ResourceInitializationException {
        this.shutdownHookThread = new Thread((Runnable)new BaseUIMAAsynchronousEngineCommon_impl.UimaASShutdownHook((UimaAsynchronousEngine)this));
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        VersionCompatibilityChecker.check((Class)CLASS_NAME, (String)"UIMA AS Client", (String)"initialize");
        if (this.running) {
            throw new ResourceInitializationException((Throwable)new UIMA_IllegalStateException());
        }
        this.reset();
        Properties performanceTuningSettings = null;
        if (!anApplicationContext.containsKey("ServerURI")) {
            throw new ResourceInitializationException();
        }
        if (!anApplicationContext.containsKey("Endpoint")) {
            throw new ResourceInitializationException();
        }
        ResourceManager rm = null;
        rm = anApplicationContext.containsKey("RESOURCE_MANAGER") ? (ResourceManager)anApplicationContext.get("RESOURCE_MANAGER") : UIMAFramework.newDefaultResourceManager();
        performanceTuningSettings = new Properties();
        if (anApplicationContext.containsKey("cas_initial_heap_size")) {
            String cas_initial_heap_size = (String)anApplicationContext.get("cas_initial_heap_size");
            performanceTuningSettings.put("cas_initial_heap_size", cas_initial_heap_size);
        }
        this.asynchManager = new AsynchAECasManager_impl(rm);
        this.brokerURI = (String)anApplicationContext.get("ServerURI");
        this.endpoint = (String)anApplicationContext.get("Endpoint");
        this.brokerURI = this.replacePlaceholder(this.brokerURI);
        this.endpoint = this.replacePlaceholder(this.endpoint);
        this.clientSideJmxStats.setEndpointName(this.endpoint);
        int casPoolSize = 1;
        if (anApplicationContext.containsKey("CasPoolSize")) {
            casPoolSize = (Integer)anApplicationContext.get("CasPoolSize");
            this.clientSideJmxStats.setCasPoolSize(casPoolSize);
        }
        if (anApplicationContext.containsKey("Timeout")) {
            this.processTimeout = (Integer)anApplicationContext.get("Timeout");
        }
        if (anApplicationContext.containsKey("GetMetaTimeout")) {
            this.metadataTimeout = (Integer)anApplicationContext.get("GetMetaTimeout");
        }
        if (anApplicationContext.containsKey("CpcTimeout")) {
            this.cpcTimeout = (Integer)anApplicationContext.get("CpcTimeout");
        }
        if (anApplicationContext.containsKey("ApplicationName")) {
            this.applicationName = (String)anApplicationContext.get("ApplicationName");
        }
        if (anApplicationContext.containsKey("SerializationStrategy")) {
            String serializationStrategy = (String)anApplicationContext.get("SerializationStrategy");
            this.setSerialFormat(serializationStrategy.equalsIgnoreCase("xmi") ? SerialFormat.XMI : SerialFormat.BINARY);
            this.clientSideJmxStats.setSerialization(this.getSerialFormat());
        }
        if (anApplicationContext.containsKey(UimaAsynchronousEngine.userName)) {
            this.amqUser = (String)anApplicationContext.get(UimaAsynchronousEngine.userName);
        }
        if (anApplicationContext.containsKey(UimaAsynchronousEngine.password)) {
            this.amqPassword = (String)anApplicationContext.get(UimaAsynchronousEngine.password);
        }
        if (anApplicationContext.containsKey("TimerPerCAS")) {
            this.timerPerCAS = (Boolean)anApplicationContext.get("TimerPerCAS");
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", "jms_adapter_messages", "UIMAJMS_init_uimaee_client__CONFIG", new Object[]{this.brokerURI, 0, casPoolSize, this.processTimeout, this.metadataTimeout, this.cpcTimeout, this.timerPerCAS});
        }
        this.serviceDelegate = new ClientServiceDelegate(this.endpoint, this.applicationName, (BaseUIMAAsynchronousEngineCommon_impl)this);
        this.serviceDelegate.setCasProcessTimeout((long)this.processTimeout);
        this.serviceDelegate.setGetMetaTimeout((long)this.metadataTimeout);
        try {
            String uuid = UUIDGenerator.generate();
            uuid = uuid.replaceAll(":", "_");
            uuid = uuid.replaceAll("-", "_");
            this.applicationName = this.applicationName + "_" + uuid;
            this.jmxManager = new JmxManager("org.apache.uima");
            this.clientSideJmxStats.setApplicationName(this.applicationName);
            this.clientJmxObjectName = new ObjectName("org.apache.uima:name=" + this.applicationName);
            this.jmxManager.registerMBean((Object)this.clientSideJmxStats, this.clientJmxObjectName);
            this.createSharedConnection(this.brokerURI);
            this.running = true;
            try {
                ((Object)((Object)this)).wait(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sendMetaRequest();
            this.waitForMetadataReply();
            if (this.abort || !this.running) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "initialize", "jms_adapter_messages", "UIMAJMS_aborting_as_WARNING", new Object[]{"Metadata Timeout"});
                }
                throw new ResourceInitializationException((Throwable)new UimaASMetaRequestTimeout());
            }
            if (this.collectionReader != null) {
                this.asynchManager.addMetadata(this.collectionReader.getProcessingResourceMetaData());
            }
            this.asynchManager.initialize(casPoolSize, "ApplicationCasPoolContext", performanceTuningSettings);
            if (this.resourceMetadata != null && this.resourceMetadata instanceof AnalysisEngineMetaData && ((AnalysisEngineMetaData)this.resourceMetadata).getOperationalProperties().getOutputsNewCASes()) {
                this.asynchManager.initialize(1, "ShadowCasPool", performanceTuningSettings);
            }
            this.initialized = true;
            this.remoteService = true;
            for (int i = 0; this.listeners != null && i < this.listeners.size(); ++i) {
                ((UimaASStatusCallbackListener)this.listeners.get(i)).initializationComplete(null);
            }
        }
        catch (ResourceInitializationException e) {
            this.state = BaseUIMAAsynchronousEngineCommon_impl.ClientState.FAILED;
            this.notifyOnInitializationFailure((Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            this.state = BaseUIMAAsynchronousEngineCommon_impl.ClientState.FAILED;
            this.notifyOnInitializationFailure(e);
            throw new ResourceInitializationException((Throwable)e);
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "initialize", "jms_adapter_messages", "UIMAJMS_as_initialized__INFO", new Object[]{"SerializationStrategy"});
        }
        super.acquireCpcReadySemaphore();
        this.state = BaseUIMAAsynchronousEngineCommon_impl.ClientState.RUNNING;
    }

    public String deploy(String aDeploymentDescriptor, Map anApplicationContext) throws Exception {
        String string;
        String springContext = null;
        try {
            springContext = this.generateSpringContext(aDeploymentDescriptor, anApplicationContext);
            SpringContainerDeployer springDeployer = new SpringContainerDeployer(this.springContainerRegistry, this);
            String id = springDeployer.deploy(springContext);
            if (springDeployer.isInitialized()) {
                springDeployer.startListeners();
            }
            string = id;
        }
        catch (Exception e) {
            try {
                this.running = true;
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "main", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                String uimaAsDebug = (String)anApplicationContext.get("-uimaEeDebug");
                if (springContext != null && (null == uimaAsDebug || uimaAsDebug.equals(""))) {
                    this.disposeContextFiles(springContext);
                }
                throw throwable;
            }
        }
        String uimaAsDebug = (String)anApplicationContext.get("-uimaEeDebug");
        if (springContext != null && (null == uimaAsDebug || uimaAsDebug.equals(""))) {
            this.disposeContextFiles(springContext);
        }
        return string;
    }

    private void disposeContextFiles(String ... contextFiles) {
        for (String contextFile : contextFiles) {
            File file = new File(contextFile);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    public String deploy(String[] aDeploymentDescriptorList, Map anApplicationContext) throws Exception {
        if (aDeploymentDescriptorList == null) {
            throw new ResourceConfigurationException("illegal_argument", new Object[]{"Null", "DeploymentDescriptorList", "deploy()"});
        }
        if (aDeploymentDescriptorList.length == 0) {
            throw new ResourceConfigurationException("mandatory_value_missing", new Object[]{"DeploymentDescriptorList"});
        }
        String[] springContextFiles = new String[aDeploymentDescriptorList.length];
        for (int i = 0; i < aDeploymentDescriptorList.length; ++i) {
            springContextFiles[i] = this.generateSpringContext(aDeploymentDescriptorList[i], anApplicationContext);
        }
        SpringContainerDeployer springDeployer = new SpringContainerDeployer(this.springContainerRegistry);
        try {
            String id = springDeployer.deploy(springContextFiles);
            if (springDeployer.isInitialized()) {
                springDeployer.startListeners();
            }
            String string = id;
            return string;
        }
        catch (ResourceInitializationException e) {
            this.running = true;
            throw e;
        }
        finally {
            String uimaAsDebug = (String)anApplicationContext.get("-uimaEeDebug");
            if (null == uimaAsDebug || uimaAsDebug.equals("")) {
                this.disposeContextFiles(springContextFiles);
            }
        }
    }

    public void undeploy() throws Exception {
        Iterator containerIterator = ((ConcurrentHashMap.KeySetView)this.springContainerRegistry.keySet()).iterator();
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
            String msg = "undeploying " + this.springContainerRegistry.size() + " Containers";
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "undeploy", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
        }
        while (containerIterator.hasNext()) {
            String containerId = (String)containerIterator.next();
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                String msg = "Undeploying Container Id:" + containerId;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "undeploy", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
            }
            this.undeploy(containerId);
        }
    }

    public void undeploy(String aSpringContainerId) throws Exception {
        this.undeploy(aSpringContainerId, 1001);
    }

    public void undeploy(String aSpringContainerId, int stop_level) throws Exception {
        if (aSpringContainerId == null) {
            return;
        }
        UimaEEAdminSpringContext adminContext = null;
        if (!this.springContainerRegistry.containsKey(aSpringContainerId)) {
            return;
        }
        adminContext = (UimaEEAdminSpringContext)this.springContainerRegistry.get(aSpringContainerId);
        if (adminContext == null) {
            throw new InvalidContainerException("Spring Container Does Not Contain Valid UimaEEAdminSpringContext Object");
        }
        ApplicationContext ctx = adminContext.getSpringContainer();
        String[] asyncServiceList = ctx.getBeanNamesForType(ControllerLifecycle.class);
        if (asyncServiceList != null && asyncServiceList.length > 0) {
            boolean topLevelController = false;
            ControllerLifecycle ctrer = null;
            int indx = 0;
            while (!topLevelController) {
                if (!((ctrer = (ControllerLifecycle)ctx.getBean(asyncServiceList[indx++])) instanceof UimacppServiceController) && !((AnalysisEngineController)ctrer).isTopLevelComponent()) continue;
                topLevelController = true;
            }
            if (ctrer != null) {
                String msg;
                if (ctrer instanceof AnalysisEngineController && ((AnalysisEngineController)ctrer).getControllerLatch() != null) {
                    ((AnalysisEngineController)ctrer).getControllerLatch().release();
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                    msg = "++++++++++++++++++++++ calling terminate()-service:" + ((AnalysisEngineController)ctrer).getComponentName();
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "undeploy", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
                }
                switch (stop_level) {
                    case 1000: {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                            msg = "++++++++++++++++++++++ calling quiesceAndStop()";
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "undeploy", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
                        }
                        ((AnalysisEngineController)ctrer).quiesceAndStop();
                        break;
                    }
                    case 1001: {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                            msg = "++++++++++++++++++++++ calling terminate()";
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "undeploy", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
                        }
                        ((AnalysisEngineController)ctrer).terminate();
                    }
                }
            }
        }
        if (ctx instanceof FileSystemXmlApplicationContext) {
            ((FileSystemXmlApplicationContext)ctx).destroy();
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                String msg = "---------------------- Destroying Application Context:" + ((FileSystemXmlApplicationContext)ctx).getApplicationName();
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "undeploy", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
            }
        }
        this.springContainerRegistry.remove(aSpringContainerId);
    }

    private String generateSpringContext(String aDeploymentDescriptor, Map anApplicationContext) throws Exception {
        String dd2SpringXsltFilePath = null;
        String saxonClasspath = null;
        if (!anApplicationContext.containsKey("DD2SpringXsltFilePath")) {
            throw new ResourceConfigurationException("mandatory_value_missing", new Object[]{"Xslt File Path"});
        }
        dd2SpringXsltFilePath = (String)anApplicationContext.get("DD2SpringXsltFilePath");
        if (!anApplicationContext.containsKey("SaxonClasspath")) {
            throw new ResourceConfigurationException("mandatory_value_missing", new Object[]{"Saxon Classpath"});
        }
        saxonClasspath = (String)anApplicationContext.get("SaxonClasspath");
        Dd2spring dd2Spring = new Dd2spring();
        File springContextFile = dd2Spring.convertDd2Spring(aDeploymentDescriptor, dd2SpringXsltFilePath, saxonClasspath, (String)anApplicationContext.get("-uimaEeDebug"));
        return springContextFile.getAbsolutePath();
    }

    protected String deploySpringContainer(String[] springContextFiles) throws ResourceInitializationException {
        SpringContainerDeployer springDeployer = new SpringContainerDeployer(this);
        try {
            return springDeployer.deploy(springContextFiles);
        }
        catch (ResourceInitializationException e) {
            this.running = true;
            throw e;
        }
    }

    protected void waitForServiceNotification() throws Exception {
        while (!this.serviceInitializationCompleted) {
            if (this.serviceInitializationException) {
                throw new ResourceInitializationException();
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "waitForServiceNotification", "jms_adapter_messages", "UIMAJMS_awaiting_container_init__INFO", new Object[0]);
            }
            try {
                this.serviceSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.serviceSemaphore.release();
            }
            if (!this.serviceInitializationException) continue;
            throw new ResourceInitializationException();
        }
    }

    protected void deployEmbeddedBroker() throws Exception {
    }

    public static void main(String[] args) {
        block2: {
            try {
                BaseUIMAAsynchronousEngine_impl uimaee = new BaseUIMAAsynchronousEngine_impl();
                HashMap<String, String> appContext = new HashMap<String, String>();
                appContext.put("DD2SpringXsltFilePath", args[1]);
                appContext.put("SaxonClasspath", args[2]);
                String containerId = uimaee.deploy(args[0], appContext);
                uimaee.undeploy(containerId);
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block2;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "main", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
    }

    public void setReleaseCASMessage(TextMessage msg, String aCasReferenceId) throws Exception {
        msg.setIntProperty("Payload", 1005);
        msg.setStringProperty("CasReference", aCasReferenceId);
        msg.setIntProperty("MessageType", 3000);
        msg.setIntProperty("Command", 2005);
        msg.setStringProperty("ServerURI", this.brokerURI);
        msg.setJMSReplyTo((Destination)this.consumerDestination);
    }

    public void notifyOnInitializationFailure(Exception e) {
        this.notifyOnInitializationFailure(null, e);
    }

    public void notifyOnInitializationSuccess() {
        this.notifyOnInitializationSuccess(null);
    }

    public void notifyOnInitializationFailure(AnalysisEngineController aController, Exception e) {
        this.serviceInitializationException = true;
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "notifyOnInitializationFailure", "jms_adapter_messages", "UIMAJMS_container_init_exception__WARNING", (Throwable)e);
        }
        this.serviceSemaphore.release();
    }

    public void notifyOnInitializationSuccess(AnalysisEngineController aController) {
        this.serviceInitializationCompleted = true;
        this.serviceSemaphore.release();
    }

    public void notifyOnTermination(String aServiceName, UimaASApplicationEvent.EventTrigger cause) {
        for (int i = 0; this.listeners != null && i < this.listeners.size(); ++i) {
            UimaAsBaseCallbackListener statCL = (UimaAsBaseCallbackListener)this.listeners.get(i);
            statCL.onUimaAsServiceExit(cause);
        }
    }

    public void notifyOnTermination(String aServiceName, String aCasReferenceId, Exception cause) {
    }

    protected MessageProducer getMessageProducer(Destination destination) throws Exception {
        return this.sender.getMessageProducer(destination);
    }

    public void stopProducingCases() {
        String[] casIdsPendingReply = this.serviceDelegate.getDelegateCasIdsPendingReply();
        if (casIdsPendingReply != null && casIdsPendingReply.length > 0) {
            for (String casReferenceId : casIdsPendingReply) {
                BaseUIMAAsynchronousEngineCommon_impl.ClientRequest clientCachedRequest = (BaseUIMAAsynchronousEngineCommon_impl.ClientRequest)this.clientCache.get(casReferenceId);
                if (clientCachedRequest == null || clientCachedRequest.isMetaRequest() || clientCachedRequest.getCasReferenceId() == null) continue;
                this.stopProducingCases(casReferenceId, clientCachedRequest.getFreeCasNotificationQueue());
            }
        }
    }

    public void stopProducingCases(String aCasReferenceId) {
        BaseUIMAAsynchronousEngineCommon_impl.ClientRequest clientCachedRequest = (BaseUIMAAsynchronousEngineCommon_impl.ClientRequest)this.clientCache.get(aCasReferenceId);
        if (clientCachedRequest != null) {
            this.stopProducingCases(aCasReferenceId, clientCachedRequest.getFreeCasNotificationQueue());
        }
    }

    private void stopProducingCases(String casReferenceId, Destination cmFreeCasQueue) {
        block4: {
            PendingMessage msg = new PendingMessage(2006);
            msg.put((Object)"Destination", (Object)cmFreeCasQueue);
            msg.put((Object)"CasReference", (Object)casReferenceId);
            try {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "stopProducingCases", "jms_adapter_messages", "UIMAJMS_client_sending_stop_to_service__INFO", new Object[]{casReferenceId, cmFreeCasQueue});
                }
                this.sender.dispatchMessage(msg, this, false);
            }
            catch (Exception ex) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stopProducingCases", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)ex);
                }
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block4;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stopProducingCases", "jms_adapter_messages", "UIMAJMS_client_unable_to_send_stop_to_cm__WARNING");
            }
        }
    }

    protected void dispatchFreeCasRequest(String casReferenceId, Message message) throws Exception {
        PendingMessage msg = new PendingMessage(2005);
        msg.put((Object)"Destination", (Object)message.getJMSReplyTo());
        msg.put((Object)"CasReference", (Object)casReferenceId);
        this.sender.dispatchMessage(msg, this, false);
    }

    protected MessageSender getDispatcher() {
        return this.sender;
    }

    public void notifyOnReconnecting(String aMessage) {
    }

    public void notifyOnReconnectionSuccess() {
    }

    public void onApplicationEvent(ApplicationEvent event) {
        for (int i = 0; this.listeners != null && i < this.listeners.size(); ++i) {
            UimaAsBaseCallbackListener statCL = (UimaAsBaseCallbackListener)this.listeners.get(i);
            if (!(event instanceof UimaASApplicationExitEvent)) continue;
            statCL.onUimaAsServiceExit(((UimaASApplicationExitEvent)event).getEventTrigger());
        }
    }

    public class ClientExceptionListener
    implements ExceptionListener {
        public void onException(JMSException arg0) {
            arg0.printStackTrace();
        }
    }
}

