/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.analysis_engine.impl.RsFeat;
import org.apache.uima.analysis_engine.impl.RsLangs;

public class RsFeats
implements Iterable<RsFeat> {
    List<RsFeat> features = null;
    static final Iterator<RsFeat> nullIterator = new Iterator<RsFeat>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public RsFeat next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };

    RsFeats() {
    }

    RsFeats(RsFeats other) {
        if (other.features == null) {
            this.features = null;
            return;
        }
        this.features = new ArrayList<RsFeat>(other.features.size());
        for (RsFeat f : other.features) {
            this.features.add(new RsFeat(f));
        }
    }

    int size() {
        return this.features == null ? 0 : this.features.size();
    }

    void add(String shortFeatName, Object languages) {
        RsFeat feat;
        if (languages instanceof String[]) {
            String[] saLangs = (String[])languages;
            feat = new RsFeat(shortFeatName, saLangs);
        } else {
            RsLangs rsLangs = (RsLangs)languages;
            rsLangs.setShared();
            feat = new RsFeat(shortFeatName, rsLangs);
        }
        if (null == this.features) {
            this.features = new ArrayList<RsFeat>(1);
        }
        this.features.add(feat);
    }

    void remove(String typeName, String shortFeatName) {
        Iterator<RsFeat> it = this.features.iterator();
        while (it.hasNext()) {
            if (!shortFeatName.equals(it.next().shortFeatName)) continue;
            it.remove();
            return;
        }
    }

    boolean contains(String typeName, String shortFeatName) {
        if (null == this.features || this.features.size() == 0) {
            return false;
        }
        return null != this.get(shortFeatName);
    }

    RsFeat get(String shortFeatName) {
        for (RsFeat r : this.features) {
            if (!r.shortFeatName.equals(shortFeatName)) continue;
            return r;
        }
        return null;
    }

    @Override
    public Iterator<RsFeat> iterator() {
        return null == this.features ? nullIterator : this.features.iterator();
    }
}

