/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Collections;
import java.util.Iterator;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.EmptyFloatList;
import org.apache.uima.jcas.cas.NonEmptyFloatList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;

public class FloatList
extends TOP
implements Iterable<Float> {
    public static final int typeIndexID;
    public static final int type;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    protected FloatList() {
    }

    public FloatList(int addr, TOP_Type type) {
        super(addr, type);
    }

    public FloatList(JCas jcas) {
        super(jcas);
    }

    public float getNthElement(int i) {
        if (this instanceof EmptyFloatList) {
            CASRuntimeException casEx = new CASRuntimeException("JCAS_GET_NTH_ON_EMPTY_LIST", new String[]{"EmptyFloatList"});
            throw casEx;
        }
        if (i < 0) {
            CASRuntimeException casEx = new CASRuntimeException("JCAS_GET_NTH_NEGATIVE_INDEX", new String[]{Integer.toString(i)});
            throw casEx;
        }
        int originali = i;
        FloatList cg = this;
        while (true) {
            if (cg instanceof EmptyFloatList) {
                CASRuntimeException casEx = new CASRuntimeException("JCAS_GET_NTH_PAST_END", new String[]{Integer.toString(originali)});
                throw casEx;
            }
            NonEmptyFloatList c = (NonEmptyFloatList)cg;
            if (i == 0) {
                return c.getHead();
            }
            cg = c.getTail();
            --i;
        }
    }

    public NonEmptyFloatList push(float item) {
        return new NonEmptyFloatList(this.jcasType.jcas, item, this);
    }

    @Override
    public Iterator<Float> iterator() {
        return Collections.emptyIterator();
    }

    static {
        type = typeIndexID = JCasRegistry.register(FloatList.class);
    }
}

