/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.error;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.ErrorHandler;

public class ErrorHandlerChain
extends LinkedList {
    public ErrorHandlerChain(List aChainofHandlers) {
        this.addAll(aChainofHandlers);
    }

    public Map getThresholds() {
        HashMap thresholds = new HashMap();
        for (ErrorHandler handler : this) {
            Map thresholdMap = handler.getEndpointThresholdMap();
            thresholds.putAll(thresholdMap);
        }
        return thresholds;
    }

    public void handle(Throwable t, ErrorContext anErrorContext, AnalysisEngineController aController) {
        boolean errorHandled = false;
        if (this.size() > 0) {
            Throwable cause = t;
            if (t instanceof AsynchAEException && t.getCause() != null) {
                cause = t.getCause();
            }
            Iterator iterator = this.iterator();
            while (!errorHandled && iterator.hasNext()) {
                ErrorHandler handler = (ErrorHandler)iterator.next();
                errorHandled = handler.handleError(cause, anErrorContext, aController);
            }
        }
    }
}

