/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.spi.transport.vm;

import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.Endpoint_impl;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.message.MessageContext;
import org.apache.uima.aae.spi.transport.vm.UimaVmMessage;

public class VmMessageContext
implements MessageContext {
    private Endpoint endpoint;
    private UimaVmMessage message = null;
    private String endpointName = null;

    public VmMessageContext(UimaVmMessage aMessage, String anEndpointName) throws AsynchAEException {
        this.message = aMessage;
        this.endpoint = new Endpoint_impl();
        this.endpointName = anEndpointName;
        try {
            String msgFrom = aMessage.getStringProperty("MessageFrom");
            if (msgFrom != null) {
                this.endpoint.setEndpoint(msgFrom);
            }
            if (aMessage.containsProperty("ServerURI")) {
                String selectedServerURI = aMessage.getStringProperty("ServerURI");
                this.endpoint.setServerURI(selectedServerURI);
                this.endpoint.setRemote(!this.endpoint.getServerURI().startsWith("vm"));
            }
            if (aMessage.containsProperty("EndpointServer")) {
                this.endpoint.setRemote(true);
                this.endpoint.setEndpointServer(aMessage.getStringProperty("EndpointServer"));
            }
        }
        catch (Exception e) {
            throw new AsynchAEException(e);
        }
    }

    @Override
    public byte[] getByteMessage() throws AsynchAEException {
        return this.message.getStringCargo().getBytes();
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getEndpointName() {
        return this.endpointName;
    }

    @Override
    public long getMessageArrivalTime() {
        return 0L;
    }

    @Override
    public int getMessageIntProperty(String messagePropertyName) throws AsynchAEException {
        return this.message.getIntProperty(messagePropertyName);
    }

    @Override
    public long getMessageLongProperty(String messagePropertyName) throws AsynchAEException {
        return this.message.getLongProperty(messagePropertyName);
    }

    @Override
    public Object getMessageObjectProperty(String messagePropertyName) throws AsynchAEException {
        return this.message.getObjectProperty(messagePropertyName);
    }

    @Override
    public String getMessageStringProperty(String messagePropertyName) throws AsynchAEException {
        return this.message.getStringProperty(messagePropertyName);
    }

    @Override
    public Object getObjectMessage() throws AsynchAEException {
        return this.message.getObjectProperty("Cargo");
    }

    @Override
    public Object getRawMessage() {
        return this.message;
    }

    @Override
    public String getStringMessage() throws AsynchAEException {
        return this.message.getStringCargo();
    }

    @Override
    public boolean propertyExists(String key) throws AsynchAEException {
        return this.message.containsKey(key);
    }

    @Override
    public void setMessageArrivalTime(long anArrivalTime) {
    }

    @Override
    public boolean getMessageBooleanProperty(String messagePropertyName) throws AsynchAEException {
        return this.message.getBooleanProperty(messagePropertyName);
    }
}

