/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class Closure
extends Value {
    protected Expression expression;
    protected XPathContextMajor savedXPathContext;
    protected int depth = 0;
    protected SequenceIterator inputIterator;

    public static Closure makeIteratorClosure(SequenceIterator sequenceIterator) {
        Closure closure = new Closure();
        closure.inputIterator = sequenceIterator;
        return closure;
    }

    public static Value make(Expression expression, XPathContext xPathContext, int n) throws XPathException {
        Value value = xPathContext.getConfiguration().getOptimizer().makeClosure(expression, n, xPathContext);
        if (value instanceof Closure) {
            Object object;
            Object object2;
            Object object3;
            Closure closure = (Closure)value;
            closure.expression = expression;
            closure.savedXPathContext = xPathContext.newContext();
            closure.savedXPathContext.setOriginatingConstructType(2063);
            if ((expression.getDependencies() & 0x80) != 0) {
                object3 = xPathContext.getStackFrame();
                object2 = ((StackFrame)object3).getStackFrameValues();
                object = expression.getSlotsUsed();
                if (object2 != null) {
                    SlotManager slotManager = ((StackFrame)object3).getStackFrameMap();
                    ValueRepresentation[] valueRepresentationArray = new ValueRepresentation[slotManager.getNumberOfVariables()];
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        Object object4 = object[i];
                        if (object2[object4] instanceof Closure) {
                            int n2 = ((Closure)object2[object4]).depth;
                            if (n2 >= 10) {
                                object2[object4] = SequenceExtent.makeSequenceExtent(((Closure)object2[object4]).iterate());
                            } else if (n2 + 1 > closure.depth) {
                                closure.depth = n2 + 1;
                            }
                        }
                        valueRepresentationArray[object4] = object2[object4];
                    }
                    closure.savedXPathContext.setStackFrame(slotManager, valueRepresentationArray);
                }
            }
            if ((object3 = xPathContext.getCurrentIterator()) != null) {
                object2 = object3.current();
                object = SingletonIterator.makeIterator((Item)object2);
                object.next();
                closure.savedXPathContext.setCurrentIterator((SequenceIterator)object);
            }
            closure.savedXPathContext.setReceiver(null);
            return closure;
        }
        return value;
    }

    public boolean isMultiValued() {
        return true;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.expression == null) {
            return AnyItemType.getInstance();
        }
        return this.expression.getItemType(typeHierarchy);
    }

    public int getCardinality() {
        if (this.expression == null) {
            return 57344;
        }
        return this.expression.getCardinality();
    }

    public SequenceIterator iterate() throws XPathException {
        if (this.inputIterator == null) {
            this.inputIterator = this.expression.iterate(this.savedXPathContext);
            return this.inputIterator;
        }
        return this.inputIterator.getAnother();
    }

    public void process(XPathContext xPathContext) throws XPathException {
        XPathContextMajor xPathContextMajor = this.savedXPathContext.newContext();
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        xPathContextMajor.setTemporaryReceiver(sequenceReceiver);
        this.expression.process(xPathContextMajor);
    }

    public Value reduce() throws XPathException {
        return new SequenceExtent(this.iterate()).reduce();
    }
}

