/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public final class CastExpression
extends UnaryExpression {
    static IntHashMap castingTable = new IntHashMap(25);
    private AtomicType targetType;
    private AtomicType targetPrimitiveType;
    private boolean allowEmpty = false;
    private boolean derived = false;
    private boolean upcast = false;

    static void addAllowedCasts(int n, int[] nArray) {
        castingTable.put(n, nArray);
    }

    public static boolean isPossibleCast(int n, int n2) {
        int[] nArray;
        if (n == 632 || n == 15) {
            return true;
        }
        if (n == 635) {
            n = 517;
        }
        if ((nArray = (int[])castingTable.get(n)) == null) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n2) continue;
            return true;
        }
        return false;
    }

    public CastExpression(Expression expression, AtomicType atomicType, boolean bl) {
        super(expression);
        this.allowEmpty = bl;
        this.targetType = atomicType;
        this.targetPrimitiveType = (AtomicType)atomicType.getPrimitiveItemType();
        this.derived = this.targetType.getFingerprint() != this.targetPrimitiveType.getFingerprint();
        this.adoptChildExpression(expression);
    }

    public AtomicType getTargetPrimitiveType() {
        return this.targetPrimitiveType;
    }

    public AtomicType getTargetType() {
        return this.targetType;
    }

    public boolean allowsEmpty() {
        return this.allowEmpty;
    }

    public boolean targetIsDerived() {
        return this.derived;
    }

    public boolean isUpCast() {
        return this.upcast;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        if (this.targetType instanceof BuiltInAtomicType && !staticContext.isAllowedBuiltInType(this.targetType)) {
            StaticError staticError = new StaticError("The type " + this.targetType.getDisplayName() + " is not recognized by a Basic XSLT Processor", this);
            staticError.setErrorCode("XPST0080");
            throw staticError;
        }
        this.operand = this.operand.simplify(staticContext);
        if (Literal.isAtomic(this.operand)) {
            return this.typeCheck(staticContext, Type.ITEM_TYPE);
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        int n;
        this.operand = this.operand.typeCheck(staticContext, itemType);
        SequenceType sequenceType = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, this.getCardinality());
        RoleLocator roleLocator = new RoleLocator(2, "cast as", 0, null);
        roleLocator.setSourceLocator(this);
        this.operand = TypeChecker.staticTypeCheck(this.operand, sequenceType, false, roleLocator, staticContext);
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        ItemType itemType2 = this.operand.getItemType(typeHierarchy);
        if (typeHierarchy.isSubType(itemType2, this.targetType)) {
            this.upcast = true;
            return this;
        }
        if (this.operand instanceof Literal) {
            Value value = ((Literal)this.operand).getValue();
            if (value instanceof AtomicValue) {
                AtomicValue atomicValue = (AtomicValue)this.evaluateItem(staticContext.makeEarlyEvaluationContext());
                if (atomicValue instanceof StringValue) {
                    return new StringLiteral((StringValue)atomicValue);
                }
                return new Literal(atomicValue);
            }
            if (value instanceof EmptySequence) {
                if (this.allowEmpty) {
                    return this.operand;
                }
                StaticError staticError = new StaticError("Cast can never succeed: the operand must not be an empty sequence");
                staticError.setErrorCode("XPTY0004");
                staticError.setLocator(this);
                staticError.setIsTypeError(true);
                throw staticError;
            }
        }
        if (!CastExpression.isPossibleCast(n = itemType2.getPrimitiveType(), this.targetType.getPrimitiveType())) {
            StaticError staticError = new StaticError("Casting from " + itemType2 + " to " + this.targetType + " can never succeed");
            staticError.setErrorCode("XPTY0004");
            staticError.setLocator(this);
            staticError.setIsTypeError(true);
            throw staticError;
        }
        return this;
    }

    public int computeCardinality() {
        return this.allowEmpty & Cardinality.allowsZero(this.operand.getCardinality()) ? 24576 : 16384;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.targetType;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string;
        ValidationException validationException;
        AtomicValue atomicValue = (AtomicValue)this.operand.evaluateItem(xPathContext);
        if (atomicValue == null) {
            if (this.allowEmpty) {
                return null;
            }
            DynamicError dynamicError = new DynamicError("Cast does not allow an empty sequence");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setLocator(this);
            dynamicError.setErrorCode("XPTY0004");
            throw dynamicError;
        }
        if (this.upcast) {
            AtomicValue atomicValue2 = atomicValue.convert(this.targetPrimitiveType, xPathContext, false);
            if (this.derived) {
                atomicValue2 = atomicValue2.convert(this.targetType, xPathContext, false);
            }
            return atomicValue2;
        }
        AtomicValue atomicValue3 = atomicValue.convert(this.targetPrimitiveType, xPathContext, true);
        if (atomicValue3 instanceof ValidationErrorValue) {
            validationException = ((ValidationErrorValue)atomicValue3).getException();
            string = validationException.getErrorCodeLocalPart();
            this.dynamicError(validationException.getMessage(), string, xPathContext);
        }
        if (this.derived && (atomicValue3 = atomicValue3.convert(this.targetType, xPathContext, true)) instanceof ValidationErrorValue) {
            validationException = ((ValidationErrorValue)atomicValue3).getException();
            string = validationException.getErrorCodeLocalPart();
            this.dynamicError(validationException.getMessage(), string, xPathContext);
        }
        return atomicValue3;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.targetType == ((CastExpression)object).targetType && this.allowEmpty == ((CastExpression)object).allowEmpty;
    }

    protected String displayOperator(Configuration configuration) {
        return "cast as " + this.targetType.toString(configuration.getNamePool());
    }

    public static AtomicValue castStringToQName(CharSequence charSequence, AtomicType atomicType, StaticContext staticContext) throws XPathException {
        try {
            String string;
            CharSequence charSequence2 = Whitespace.trimWhitespace(charSequence);
            String[] stringArray = staticContext.getConfiguration().getNameChecker().getQNameParts(charSequence2);
            if (stringArray[0].length() == 0) {
                string = staticContext.getDefaultElementNamespace();
            } else {
                string = staticContext.getURIForPrefix(stringArray[0]);
                if (string == null) {
                    StaticError staticError = new StaticError("Prefix '" + stringArray[0] + "' has not been declared");
                    staticError.setErrorCode("FONS0004");
                    throw staticError;
                }
            }
            NameChecker nameChecker = staticContext.getConfiguration().getNameChecker();
            TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
            if (atomicType.getFingerprint() == 530) {
                return new QNameValue(stringArray[0], string, stringArray[1], BuiltInAtomicType.QNAME, nameChecker);
            }
            if (typeHierarchy.isSubType(atomicType, BuiltInAtomicType.QNAME)) {
                QNameValue qNameValue = new QNameValue(stringArray[0], string, stringArray[1], atomicType, nameChecker);
                AtomicValue atomicValue = atomicType.setDerivedTypeLabel(qNameValue, charSequence2, true);
                if (atomicValue instanceof ValidationErrorValue) {
                    throw ((ValidationErrorValue)atomicValue).getException();
                }
                return atomicValue;
            }
            NotationValue notationValue = new NotationValue(stringArray[0], string, stringArray[1], nameChecker);
            AtomicValue atomicValue = atomicType.setDerivedTypeLabel(notationValue, charSequence2, true);
            if (atomicValue instanceof ValidationErrorValue) {
                throw ((ValidationErrorValue)atomicValue).getException();
            }
            return atomicValue;
        }
        catch (XPathException xPathException) {
            StaticError staticError = new StaticError(xPathException);
            staticError.setErrorCode("FONS0004");
            throw staticError;
        }
        catch (QNameException qNameException) {
            StaticError staticError = new StaticError(qNameException);
            staticError.setErrorCode("FONS0004");
            throw staticError;
        }
    }

    static {
        int[] nArray = new int[]{631, 513, 516, 517, 515, 532, 518, 633, 634, 519, 520, 521, 522, 523, 524, 525, 526, 514, 528, 527, 529};
        CastExpression.addAllowedCasts(631, nArray);
        int[] nArray2 = new int[]{631, 513, 516, 517, 515, 532, 518, 633, 634, 519, 520, 521, 522, 523, 524, 525, 526, 514, 528, 527, 529, 530, 531};
        CastExpression.addAllowedCasts(513, nArray2);
        int[] nArray3 = new int[]{631, 513, 516, 517, 515, 532, 514};
        CastExpression.addAllowedCasts(516, nArray3);
        CastExpression.addAllowedCasts(517, nArray3);
        CastExpression.addAllowedCasts(515, nArray3);
        CastExpression.addAllowedCasts(532, nArray3);
        int[] nArray4 = new int[]{631, 513, 518, 633, 634};
        CastExpression.addAllowedCasts(518, nArray4);
        CastExpression.addAllowedCasts(633, nArray4);
        CastExpression.addAllowedCasts(634, nArray4);
        int[] nArray5 = new int[]{631, 513, 519, 520, 521, 522, 523, 524, 525, 526};
        CastExpression.addAllowedCasts(519, nArray5);
        int[] nArray6 = new int[]{631, 513, 520};
        CastExpression.addAllowedCasts(520, nArray6);
        int[] nArray7 = new int[]{631, 513, 519, 521, 522, 523, 524, 525, 526};
        CastExpression.addAllowedCasts(521, nArray7);
        int[] nArray8 = new int[]{631, 513, 522};
        CastExpression.addAllowedCasts(522, nArray8);
        int[] nArray9 = new int[]{631, 513, 523};
        CastExpression.addAllowedCasts(523, nArray9);
        int[] nArray10 = new int[]{631, 513, 524};
        CastExpression.addAllowedCasts(524, nArray10);
        int[] nArray11 = new int[]{631, 513, 525};
        CastExpression.addAllowedCasts(525, nArray11);
        int[] nArray12 = new int[]{631, 513, 526};
        CastExpression.addAllowedCasts(526, nArray12);
        int[] nArray13 = new int[]{631, 513, 516, 517, 515, 532, 514};
        CastExpression.addAllowedCasts(514, nArray13);
        int[] nArray14 = new int[]{631, 513, 528, 527};
        CastExpression.addAllowedCasts(528, nArray14);
        CastExpression.addAllowedCasts(527, nArray14);
        int[] nArray15 = new int[]{631, 513, 529};
        CastExpression.addAllowedCasts(529, nArray15);
        int[] nArray16 = new int[]{631, 513, 530};
        CastExpression.addAllowedCasts(530, nArray16);
        int[] nArray17 = new int[]{631, 513, 531};
        CastExpression.addAllowedCasts(531, nArray17);
    }
}

