/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;

public class CasEditorViewPage
extends Page
implements ISelectionProvider {
    private ListenerList selectionChangedListeners = new ListenerList();
    private final String notAvailableMessage;
    protected PageBook book;
    protected IPageBookViewPage casViewPage;
    private SubActionBars subActionBar;
    private Text messageText;

    protected CasEditorViewPage(String notAvailableMessage) {
        this.notAvailableMessage = notAvailableMessage;
    }

    private void refreshActionHandlers() {
        IActionBars actionBars = this.getSite().getActionBars();
        actionBars.clearGlobalActionHandlers();
        Map newActionHandlers = this.subActionBar.getGlobalActionHandlers();
        if (newActionHandlers != null) {
            Set keys = newActionHandlers.entrySet();
            for (Map.Entry entry : keys) {
                actionBars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void selectionChanged(final SelectionChangedEvent event) {
        for (Object listener : this.selectionChangedListeners.getListeners()) {
            final ISelectionChangedListener selectionChangedListener = (ISelectionChangedListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    selectionChangedListener.selectionChanged(event);
                }
            });
        }
    }

    public ISelection getSelection() {
        if (this.casViewPage != null && this.casViewPage.getSite().getSelectionProvider() != null) {
            return this.casViewPage.getSite().getSelectionProvider().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.casViewPage != null && this.casViewPage.getSite().getSelectionProvider() != null) {
            this.casViewPage.getSite().getSelectionProvider().setSelection(selection);
        }
    }

    public void createControl(Composite parent) {
        this.book = new PageBook(parent, 0);
        this.messageText = new Text((Composite)this.book, 72);
        this.messageText.setBackground(parent.getShell().getBackground());
        this.messageText.setText(this.notAvailableMessage);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.initializeAndShowPage(this.casViewPage);
    }

    protected void initializeAndShowPage(IPageBookViewPage page) {
        if (this.book != null) {
            if (page != null) {
                page.createControl((Composite)this.book);
                this.casViewPage = page;
                ISelectionProvider selectionProvider = page.getSite().getSelectionProvider();
                selectionProvider.addSelectionChangedListener(this::selectionChanged);
                this.subActionBar = (SubActionBars)this.casViewPage.getSite().getActionBars();
                this.casViewPage.setActionBars((IActionBars)this.subActionBar);
                this.subActionBar.activate();
                this.subActionBar.updateActionBars();
                this.refreshActionHandlers();
                this.book.showPage(page.getControl());
            } else {
                this.book.showPage((Control)this.messageText);
                this.getSite().getActionBars().updateActionBars();
            }
        }
    }

    public void setCASViewPage(IPageBookViewPage page) {
        if (this.book != null && this.casViewPage != null) {
            this.casViewPage.dispose();
            this.subActionBar.dispose();
        }
        this.casViewPage = page;
        this.initializeAndShowPage(page);
    }

    public Control getControl() {
        return this.book;
    }

    public void setFocus() {
        this.book.setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.casViewPage != null) {
            this.casViewPage.dispose();
            this.subActionBar.dispose();
        }
    }
}

