/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest;

import java.util.Set;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.goals.Goal;
import org.apache.unomi.api.goals.GoalReport;
import org.apache.unomi.api.query.AggregateQuery;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.services.GoalsService;

@WebService
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
public class GoalsServiceEndPoint {
    private GoalsService goalsService;

    @WebMethod(exclude=true)
    public void setGoalsService(GoalsService goalsService) {
        this.goalsService = goalsService;
    }

    @GET
    @Path(value="/")
    public Set<Metadata> getGoalMetadatas() {
        return this.goalsService.getGoalMetadatas();
    }

    @POST
    @Path(value="/")
    public void setGoal(Goal goal) {
        this.goalsService.setGoal(goal);
    }

    @POST
    @Path(value="/query")
    public Set<Metadata> getGoalMetadatas(Query query) {
        return this.goalsService.getGoalMetadatas(query);
    }

    @GET
    @Path(value="/{goalId}")
    public Goal getGoal(@PathParam(value="goalId") String goalId) {
        return this.goalsService.getGoal(goalId);
    }

    @DELETE
    @Path(value="/{goalId}")
    public void removeGoal(@PathParam(value="goalId") String goalId) {
        this.goalsService.removeGoal(goalId);
    }

    @GET
    @Path(value="/{goalID}/report")
    public GoalReport getGoalReport(@PathParam(value="goalID") String goalId) {
        return this.goalsService.getGoalReport(goalId);
    }

    @POST
    @Path(value="/{goalID}/report")
    public GoalReport getGoalReport(@PathParam(value="goalID") String goalId, AggregateQuery query) {
        return this.goalsService.getGoalReport(goalId, query);
    }
}

