/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.Mapping;

public class MappingUpdatedAction {
    public static final Setting<TimeValue> INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING = Setting.positiveTimeSetting("indices.mapping.dynamic_timeout", TimeValue.timeValueSeconds(30L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private IndicesAdminClient client;
    private volatile TimeValue dynamicMappingUpdateTimeout;

    @Inject
    public MappingUpdatedAction(Settings settings, ClusterSettings clusterSettings) {
        this.dynamicMappingUpdateTimeout = INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING, this::setDynamicMappingUpdateTimeout);
    }

    private void setDynamicMappingUpdateTimeout(TimeValue dynamicMappingUpdateTimeout) {
        this.dynamicMappingUpdateTimeout = dynamicMappingUpdateTimeout;
    }

    public void setClient(Client client) {
        this.client = client.admin().indices();
    }

    public void updateMappingOnMaster(Index index, String type, Mapping mappingUpdate, final ActionListener<Void> listener) {
        if (type.equals("_default_")) {
            throw new IllegalArgumentException("_default_ mapping should not be updated");
        }
        ((PutMappingRequestBuilder)((PutMappingRequestBuilder)this.client.preparePutMapping(new String[0]).setConcreteIndex(index).setType(type).setSource(mappingUpdate.toString(), XContentType.JSON).setMasterNodeTimeout(this.dynamicMappingUpdateTimeout)).setTimeout(TimeValue.ZERO)).execute(new ActionListener<AcknowledgedResponse>(){

            @Override
            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                listener.onResponse(null);
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(MappingUpdatedAction.unwrapException(e));
            }
        });
    }

    private static Exception unwrapException(Exception cause) {
        return cause instanceof ElasticsearchException ? FutureUtils.unwrapEsException((ElasticsearchException)cause) : cause;
    }
}

