/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.snakeyaml.engine.v1.common;

import com.hazelcast.org.snakeyaml.engine.v1.common.CharConstants;
import java.util.Objects;

public class Anchor {
    private final String anchor;

    public Anchor(String anchor) {
        Objects.requireNonNull(anchor, "Anchor must be provided.");
        if (anchor.isEmpty()) {
            throw new IllegalArgumentException("Empty anchor.");
        }
        if (!CharConstants.ANCHOR_FORMAT.matcher(anchor).matches()) {
            throw new IllegalArgumentException("invalid character in the anchor: " + anchor);
        }
        this.anchor = anchor;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public String toString() {
        return this.anchor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Anchor anchor1 = (Anchor)o;
        return Objects.equals(this.anchor, anchor1.anchor);
    }

    public int hashCode() {
        return Objects.hash(this.anchor);
    }
}

