/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal;

import java.security.AccessController;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxMarker;
import org.ops4j.pax.logging.log4j2.internal.PaxLoggingServiceImpl;
import org.osgi.framework.Bundle;

public class PaxLoggerImpl
implements PaxLogger {
    private ExtendedLogger m_delegate;
    private String m_fqcn;
    private Bundle m_bundle;
    private PaxLoggingServiceImpl m_service;

    PaxLoggerImpl(Bundle bundle, ExtendedLogger delegate, String fqcn, PaxLoggingServiceImpl service) {
        this.m_delegate = delegate;
        this.m_fqcn = fqcn;
        this.m_bundle = bundle;
        this.m_service = service;
    }

    public void setDelegate(ExtendedLogger m_delegate) {
        this.m_delegate = m_delegate;
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isFatalEnabled();
    }

    public boolean isTraceEnabled(PaxMarker marker) {
        return this.m_delegate.isTraceEnabled(marker.log4j2Marker());
    }

    public boolean isDebugEnabled(PaxMarker marker) {
        return this.m_delegate.isDebugEnabled(marker.log4j2Marker());
    }

    public boolean isInfoEnabled(PaxMarker marker) {
        return this.m_delegate.isInfoEnabled(marker.log4j2Marker());
    }

    public boolean isWarnEnabled(PaxMarker marker) {
        return this.m_delegate.isWarnEnabled(marker.log4j2Marker());
    }

    public boolean isErrorEnabled(PaxMarker marker) {
        return this.m_delegate.isErrorEnabled(marker.log4j2Marker());
    }

    public boolean isFatalEnabled(PaxMarker marker) {
        return this.m_delegate.isFatalEnabled(marker.log4j2Marker());
    }

    public void trace(String message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.doLog(null, Level.TRACE, 4, this.m_fqcn, message, t);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.doLog(null, Level.DEBUG, 4, this.m_fqcn, message, t);
        }
    }

    public void inform(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.doLog(null, Level.INFO, 3, this.m_fqcn, message, t);
        }
    }

    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.doLog(null, Level.WARN, 2, this.m_fqcn, message, t);
        }
    }

    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.doLog(null, Level.ERROR, 1, this.m_fqcn, message, t);
        }
    }

    public void fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.doLog(null, Level.FATAL, 1, this.m_fqcn, message, t);
        }
    }

    public void trace(String message, Throwable t, String fqcn) {
        if (this.isTraceEnabled()) {
            this.doLog(null, Level.TRACE, 4, fqcn, message, t);
        }
    }

    public void debug(String message, Throwable t, String fqcn) {
        if (this.isDebugEnabled()) {
            this.doLog(null, Level.DEBUG, 4, fqcn, message, t);
        }
    }

    public void inform(String message, Throwable t, String fqcn) {
        if (this.isInfoEnabled()) {
            this.doLog(null, Level.INFO, 3, fqcn, message, t);
        }
    }

    public void warn(String message, Throwable t, String fqcn) {
        if (this.isWarnEnabled()) {
            this.doLog(null, Level.WARN, 2, fqcn, message, t);
        }
    }

    public void error(String message, Throwable t, String fqcn) {
        if (this.isErrorEnabled()) {
            this.doLog(null, Level.ERROR, 1, fqcn, message, t);
        }
    }

    public void fatal(String message, Throwable t, String fqcn) {
        if (this.isFatalEnabled()) {
            this.doLog(null, Level.FATAL, 1, fqcn, message, t);
        }
    }

    public void trace(PaxMarker marker, String message, Throwable t, String fqcn) {
        if (this.isTraceEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.TRACE, 4, fqcn, message, t);
        }
    }

    public void debug(PaxMarker marker, String message, Throwable t, String fqcn) {
        if (this.isDebugEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.DEBUG, 4, fqcn, message, t);
        }
    }

    public void inform(PaxMarker marker, String message, Throwable t, String fqcn) {
        if (this.isInfoEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.INFO, 3, fqcn, message, t);
        }
    }

    public void warn(PaxMarker marker, String message, Throwable t, String fqcn) {
        if (this.isWarnEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.WARN, 2, fqcn, message, t);
        }
    }

    public void error(PaxMarker marker, String message, Throwable t, String fqcn) {
        if (this.isErrorEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.ERROR, 1, fqcn, message, t);
        }
    }

    public void fatal(PaxMarker marker, String message, Throwable t, String fqcn) {
        if (this.isFatalEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.FATAL, 1, fqcn, message, t);
        }
    }

    public void trace(PaxMarker marker, String message, Throwable t) {
        if (this.isTraceEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.TRACE, 4, this.m_fqcn, message, t);
        }
    }

    public void debug(PaxMarker marker, String message, Throwable t) {
        if (this.isDebugEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.DEBUG, 4, this.m_fqcn, message, t);
        }
    }

    public void inform(PaxMarker marker, String message, Throwable t) {
        if (this.isInfoEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.INFO, 3, this.m_fqcn, message, t);
        }
    }

    public void warn(PaxMarker marker, String message, Throwable t) {
        if (this.isWarnEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.WARN, 2, this.m_fqcn, message, t);
        }
    }

    public void error(PaxMarker marker, String message, Throwable t) {
        if (this.isErrorEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.ERROR, 1, this.m_fqcn, message, t);
        }
    }

    public void fatal(PaxMarker marker, String message, Throwable t) {
        if (this.isFatalEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.FATAL, 1, this.m_fqcn, message, t);
        }
    }

    public int getLogLevel() {
        switch (this.m_delegate.getLevel().getStandardLevel()) {
            case TRACE: {
                return 0;
            }
            case DEBUG: {
                return 1;
            }
            case INFO: {
                return 2;
            }
            case WARN: {
                return 3;
            }
        }
        return 4;
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public PaxContext getPaxContext() {
        return this.m_service.getPaxContext();
    }

    private void doLog(Marker marker, Level level, int svcLevel, String fqcn, String message, Throwable t) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(() -> {
                this.doLog0(marker, level, svcLevel, fqcn, message, t);
                return null;
            });
        } else {
            this.doLog0(marker, level, svcLevel, fqcn, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLog0(Marker marker, Level level, int svcLevel, String fqcn, String message, Throwable t) {
        Message originalMessage = this.setDelegateContext();
        try {
            Message msg = originalMessage == null ? this.m_delegate.getMessageFactory().newMessage(message) : originalMessage;
            this.m_delegate.logMessage(fqcn, level, marker, msg, t);
        }
        finally {
            this.clearDelegateContext();
        }
        this.m_service.handleEvents(this.m_bundle, null, svcLevel, message, t);
    }

    private Message setDelegateContext() {
        Message originalMessage = null;
        Map context = this.getPaxContext().getContext();
        if (context != null) {
            originalMessage = (Message)context.remove(".log4j2_message");
            for (Map.Entry entry : context.entrySet()) {
                this.put((String)entry.getKey(), entry.getValue());
            }
        }
        if (this.m_bundle != null) {
            this.put("bundle.id", this.m_bundle.getBundleId());
            this.put("bundle.name", this.m_bundle.getSymbolicName());
            this.put("bundle.version", this.m_bundle.getVersion().toString());
        }
        this.m_service.lock(false);
        return originalMessage;
    }

    private void put(String name, Object o) {
        if (o != null) {
            ThreadContext.put((String)name, (String)o.toString());
        }
    }

    private void clearDelegateContext() {
        this.m_service.unlock(false);
        ThreadContext.remove((String)"bundle.id");
        ThreadContext.remove((String)"bundle.name");
        ThreadContext.remove((String)"bundle.version");
    }
}

