/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionDispatcher;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.metrics.MetricAdapter;
import org.apache.unomi.metrics.MetricsService;
import org.apache.unomi.scripting.ScriptExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionExecutorDispatcher {
    private static final Logger logger = LoggerFactory.getLogger((String)ActionExecutorDispatcher.class.getName());
    private static final String VALUE_NAME_SEPARATOR = "::";
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private final Map<String, ValueExtractor> valueExtractors = new HashMap<String, ValueExtractor>(11);
    private Map<String, ActionExecutor> executors = new ConcurrentHashMap<String, ActionExecutor>();
    private MetricsService metricsService;
    private Map<String, ActionDispatcher> actionDispatchers = new ConcurrentHashMap<String, ActionDispatcher>();
    private BundleContext bundleContext;
    private ScriptExecutor scriptExecutor;

    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public ActionExecutorDispatcher() {
        this.valueExtractors.put("profileProperty", new ValueExtractor(){

            @Override
            public Object extract(String valueAsString, Event event) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                return PropertyUtils.getProperty((Object)event.getProfile(), (String)("properties." + valueAsString));
            }
        });
        this.valueExtractors.put("simpleProfileProperty", new ValueExtractor(){

            @Override
            public Object extract(String valueAsString, Event event) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                return event.getProfile().getProperty(valueAsString);
            }
        });
        this.valueExtractors.put("sessionProperty", new ValueExtractor(){

            @Override
            public Object extract(String valueAsString, Event event) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                return PropertyUtils.getProperty((Object)event.getSession(), (String)("properties." + valueAsString));
            }
        });
        this.valueExtractors.put("simpleSessionProperty", new ValueExtractor(){

            @Override
            public Object extract(String valueAsString, Event event) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                return event.getSession().getProperty(valueAsString);
            }
        });
        this.valueExtractors.put("eventProperty", new ValueExtractor(){

            @Override
            public Object extract(String valueAsString, Event event) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                return PropertyUtils.getProperty((Object)event, (String)valueAsString);
            }
        });
        this.valueExtractors.put("simpleEventProperty", new ValueExtractor(){

            @Override
            public Object extract(String valueAsString, Event event) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                return event.getProperty(valueAsString);
            }
        });
        this.valueExtractors.put("script", new ValueExtractor(){

            @Override
            public Object extract(String valueAsString, Event event) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                return ActionExecutorDispatcher.this.executeScript(valueAsString, event);
            }
        });
    }

    public Action getContextualAction(Action action, Event event) {
        if (!this.hasContextualParameter(action.getParameterValues())) {
            return action;
        }
        Map<String, Object> values = this.parseMap(event, action.getParameterValues());
        Action n = new Action(action.getActionType());
        n.setParameterValues(values);
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, Object> parseMap(Event event, Map<String, Object> map) {
        values = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            value = entry.getValue();
            if (value instanceof String) {
                s = (String)value;
                try {
                    if (s.contains("${")) {
                        while (s.contains("${") && (v = this.extractValue(substring = s.substring(s.indexOf("${") + 2, s.indexOf("}")), event)) != null) {
                            s = s.replace("${" + substring + "}", v.toString());
                        }
                        value = s;
                    }
                    if (!s.contains("::")) ** GOTO lbl22
                    value = this.extractValue(s, event);
                }
                catch (UnsupportedOperationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException(e);
                }
            } else if (value instanceof Map) {
                value = this.parseMap(event, value);
            }
lbl22:
            // 6 sources

            values.put(entry.getKey(), value);
        }
        return values;
    }

    private Object extractValue(String s, Event event) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object value = null;
        String valueType = StringUtils.substringBefore((String)s, (String)VALUE_NAME_SEPARATOR);
        String valueAsString = StringUtils.substringAfter((String)s, (String)VALUE_NAME_SEPARATOR);
        ValueExtractor extractor = this.valueExtractors.get(valueType);
        if (extractor != null) {
            value = extractor.extract(valueAsString, event);
        }
        return value;
    }

    private boolean hasContextualParameter(Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String s;
            String str;
            Object value = entry.getValue();
            if (!(value instanceof String ? (str = (s = (String)value).contains(PLACEHOLDER_PREFIX) ? s.substring(s.indexOf(PLACEHOLDER_PREFIX) + 2, s.indexOf(PLACEHOLDER_SUFFIX)) : s).contains(VALUE_NAME_SEPARATOR) && this.valueExtractors.containsKey(StringUtils.substringBefore((String)str, (String)VALUE_NAME_SEPARATOR)) : value instanceof Map && this.hasContextualParameter((Map)value))) continue;
            return true;
        }
        return false;
    }

    public int execute(final Action action, final Event event) {
        String actionKey = action.getActionType().getActionExecutor();
        if (actionKey == null) {
            throw new UnsupportedOperationException("No service defined for : " + action.getActionType());
        }
        int colonPos = actionKey.indexOf(":");
        if (colonPos > 0) {
            String actionPrefix = actionKey.substring(0, colonPos);
            String actionName = actionKey.substring(colonPos + 1);
            ActionDispatcher actionDispatcher = this.actionDispatchers.get(actionPrefix);
            if (actionDispatcher == null) {
                logger.warn("Couldn't find any action dispatcher for prefix '{}', action {} won't execute !", (Object)actionPrefix, (Object)actionKey);
            }
            actionDispatcher.execute(action, event, actionName);
        } else if (this.executors.containsKey(actionKey)) {
            final ActionExecutor actionExecutor = this.executors.get(actionKey);
            try {
                return (Integer)new MetricAdapter<Integer>(this.metricsService, this.getClass().getName() + ".action." + actionKey){

                    public Integer execute(Object ... args) throws Exception {
                        return actionExecutor.execute(ActionExecutorDispatcher.this.getContextualAction(action, event), event);
                    }
                }.runWithTimer(new Object[0]);
            }
            catch (Exception e) {
                logger.error("Error executing action with key=" + actionKey, (Throwable)e);
            }
        }
        return 0;
    }

    public void bindExecutor(ServiceReference<ActionExecutor> actionExecutorServiceReference) {
        ActionExecutor actionExecutor = (ActionExecutor)this.bundleContext.getService(actionExecutorServiceReference);
        this.executors.put(actionExecutorServiceReference.getProperty("actionExecutorId").toString(), actionExecutor);
    }

    public void unbindExecutor(ServiceReference<ActionExecutor> actionExecutorServiceReference) {
        if (actionExecutorServiceReference == null) {
            return;
        }
        this.executors.remove(actionExecutorServiceReference.getProperty("actionExecutorId").toString());
    }

    public void bindDispatcher(ServiceReference<ActionDispatcher> actionDispatcherServiceReference) {
        ActionDispatcher actionDispatcher = (ActionDispatcher)this.bundleContext.getService(actionDispatcherServiceReference);
        this.actionDispatchers.put(actionDispatcher.getPrefix(), actionDispatcher);
    }

    public void unbindDispatcher(ServiceReference<ActionDispatcher> actionDispatcherServiceReference) {
        if (actionDispatcherServiceReference == null) {
            return;
        }
        ActionDispatcher actionDispatcher = (ActionDispatcher)this.bundleContext.getService(actionDispatcherServiceReference);
        if (actionDispatcher != null) {
            this.actionDispatchers.remove(actionDispatcher.getPrefix());
        }
    }

    protected Object executeScript(String script, Event event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("event", event);
        context.put("session", event.getSession());
        context.put("profile", event.getProfile());
        return this.scriptExecutor.execute(script, context);
    }

    private static interface ValueExtractor {
        public Object extract(String var1, Event var2) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException;
    }
}

