/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.conditions;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionContextHelper;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilderDispatcher;
import org.apache.unomi.plugins.baseplugin.conditions.PropertyConditionEvaluator;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class PropertyConditionESQueryBuilder
implements ConditionESQueryBuilder {
    DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();

    public QueryBuilder buildQuery(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        String comparisonOperator = (String)condition.getParameter("comparisonOperator");
        String name = (String)condition.getParameter("propertyName");
        if (comparisonOperator == null || name == null) {
            throw new IllegalArgumentException("Impossible to build ES filter, condition is not valid, comparisonOperator and propertyName properties should be provided");
        }
        String expectedValue = ConditionContextHelper.foldToASCII((String)((String)condition.getParameter("propertyValue")));
        Object expectedValueInteger = condition.getParameter("propertyValueInteger");
        Object expectedValueDouble = condition.getParameter("propertyValueDouble");
        Object expectedValueDate = this.convertDateToISO(condition.getParameter("propertyValueDate"));
        Object expectedValueDateExpr = condition.getParameter("propertyValueDateExpr");
        List expectedValues = ConditionContextHelper.foldToASCII((List)((List)condition.getParameter("propertyValues")));
        List expectedValuesInteger = (List)condition.getParameter("propertyValuesInteger");
        List expectedValuesDouble = (List)condition.getParameter("propertyValuesDouble");
        List<?> expectedValuesDate = this.convertDatesToISO((List)condition.getParameter("propertyValuesDate"));
        List expectedValuesDateExpr = (List)condition.getParameter("propertyValuesDateExpr");
        Object value = ObjectUtils.firstNonNull((Object[])new Object[]{expectedValue, expectedValueInteger, expectedValueDouble, expectedValueDate, expectedValueDateExpr});
        List values = (List)ObjectUtils.firstNonNull((Object[])new List[]{expectedValues, expectedValuesInteger, expectedValuesDouble, expectedValuesDate, expectedValuesDateExpr});
        switch (comparisonOperator) {
            case "equals": {
                this.checkRequiredValue(value, name, comparisonOperator, false);
                return QueryBuilders.termQuery((String)name, (Object)value);
            }
            case "notEquals": {
                this.checkRequiredValue(value, name, comparisonOperator, false);
                return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)name, (Object)value));
            }
            case "greaterThan": {
                this.checkRequiredValue(value, name, comparisonOperator, false);
                return QueryBuilders.rangeQuery((String)name).gt(value);
            }
            case "greaterThanOrEqualTo": {
                this.checkRequiredValue(value, name, comparisonOperator, false);
                return QueryBuilders.rangeQuery((String)name).gte(value);
            }
            case "lessThan": {
                this.checkRequiredValue(value, name, comparisonOperator, false);
                return QueryBuilders.rangeQuery((String)name).lt(value);
            }
            case "lessThanOrEqualTo": {
                this.checkRequiredValue(value, name, comparisonOperator, false);
                return QueryBuilders.rangeQuery((String)name).lte(value);
            }
            case "between": {
                this.checkRequiredValuesSize(values, name, comparisonOperator, 2);
                return QueryBuilders.rangeQuery((String)name).gte(values.get(0)).lte(values.get(1));
            }
            case "exists": {
                return QueryBuilders.existsQuery((String)name);
            }
            case "missing": {
                return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)name));
            }
            case "contains": {
                this.checkRequiredValue(expectedValue, name, comparisonOperator, false);
                return QueryBuilders.regexpQuery((String)name, (String)(".*" + expectedValue + ".*"));
            }
            case "notContains": {
                this.checkRequiredValue(expectedValue, name, comparisonOperator, false);
                return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.regexpQuery((String)name, (String)(".*" + expectedValue + ".*")));
            }
            case "startsWith": {
                this.checkRequiredValue(expectedValue, name, comparisonOperator, false);
                return QueryBuilders.prefixQuery((String)name, (String)expectedValue);
            }
            case "endsWith": {
                this.checkRequiredValue(expectedValue, name, comparisonOperator, false);
                return QueryBuilders.regexpQuery((String)name, (String)(".*" + expectedValue));
            }
            case "matchesRegex": {
                this.checkRequiredValue(expectedValue, name, comparisonOperator, false);
                return QueryBuilders.regexpQuery((String)name, (String)expectedValue);
            }
            case "in": {
                this.checkRequiredValue(values, name, comparisonOperator, true);
                return QueryBuilders.termsQuery((String)name, (Object[])values.toArray());
            }
            case "notIn": {
                this.checkRequiredValue(values, name, comparisonOperator, true);
                return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)name, (Object[])values.toArray()));
            }
            case "all": {
                this.checkRequiredValue(values, name, comparisonOperator, true);
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                for (Object curValue : values) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)name, curValue));
                }
                return boolQueryBuilder;
            }
            case "inContains": {
                this.checkRequiredValue(values, name, comparisonOperator, true);
                BoolQueryBuilder boolQueryBuilderInContains = QueryBuilders.boolQuery();
                for (Object curValue : values) {
                    boolQueryBuilderInContains.must((QueryBuilder)QueryBuilders.regexpQuery((String)name, (String)(".*" + curValue + ".*")));
                }
                return boolQueryBuilderInContains;
            }
            case "hasSomeOf": {
                this.checkRequiredValue(values, name, comparisonOperator, true);
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                for (Object curValue : values) {
                    boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)name, curValue));
                }
                return boolQueryBuilder;
            }
            case "hasNoneOf": {
                this.checkRequiredValue(values, name, comparisonOperator, true);
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                for (Object curValue : values) {
                    boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)name, curValue));
                }
                return boolQueryBuilder;
            }
            case "isDay": {
                this.checkRequiredValue(value, name, comparisonOperator, false);
                return this.getIsSameDayRange(PropertyConditionEvaluator.getDate(value), name);
            }
            case "isNotDay": {
                this.checkRequiredValue(value, name, comparisonOperator, false);
                return QueryBuilders.boolQuery().mustNot(this.getIsSameDayRange(PropertyConditionEvaluator.getDate(value), name));
            }
        }
        return null;
    }

    private void checkRequiredValuesSize(List<?> values, String name, String operator, int expectedSize) {
        if (values == null || values.size() != expectedSize) {
            throw new IllegalArgumentException("Impossible to build ES filter, missing " + expectedSize + " values for a condition using comparisonOperator: " + operator + ", and propertyName: " + name);
        }
    }

    private void checkRequiredValue(Object value, String name, String operator, boolean multiple) {
        if (value == null) {
            throw new IllegalArgumentException("Impossible to build ES filter, missing value" + (multiple ? "s" : "") + " for condition using comparisonOperator: " + operator + ", and propertyName: " + name);
        }
    }

    private QueryBuilder getIsSameDayRange(Object value, String name) {
        DateTime date = new DateTime(value);
        DateTime dayStart = date.withTimeAtStartOfDay();
        DateTime dayAfterStart = date.plusDays(1).withTimeAtStartOfDay();
        return QueryBuilders.rangeQuery((String)name).gte(this.convertDateToISO(dayStart.toDate())).lte(this.convertDateToISO(dayAfterStart.toDate()));
    }

    private Object convertDateToISO(Object dateValue) {
        if (dateValue == null) {
            return dateValue;
        }
        if (dateValue instanceof Date) {
            return this.dateTimeFormatter.print((ReadableInstant)new DateTime(dateValue));
        }
        return dateValue;
    }

    private List<?> convertDatesToISO(List<?> datesValues) {
        ArrayList<Object> results = new ArrayList<Object>();
        if (datesValues == null) {
            return null;
        }
        for (Object dateValue : datesValues) {
            if (dateValue == null) continue;
            results.add(this.convertDateToISO(dateValue));
        }
        return results;
    }
}

