/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.blueprint.BlueprintPropertiesParser;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.component.properties.PropertiesResolver;

public class BlueprintPropertiesResolver
implements PropertiesResolver {
    private final PropertiesResolver delegate;
    private final BlueprintPropertiesParser blueprint;

    public BlueprintPropertiesResolver(PropertiesResolver delegate, BlueprintPropertiesParser blueprint) {
        this.delegate = delegate;
        this.blueprint = blueprint;
    }

    public Properties resolveProperties(CamelContext context, boolean ignoreMissingLocation, List<PropertiesLocation> locations) throws Exception {
        Properties answer = new Properties();
        boolean explicit = false;
        for (PropertiesLocation location : locations) {
            if ("blueprint".equals(location.getResolver())) {
                this.blueprint.addPropertyPlaceholder(location.getPath());
                explicit = true;
                continue;
            }
            answer.putAll((Map<?, ?>)this.delegate.resolveProperties(context, ignoreMissingLocation, Collections.singletonList(location)));
        }
        if (!explicit) {
            for (String id : this.blueprint.lookupPropertyPlaceholderIds()) {
                this.blueprint.addPropertyPlaceholder(id);
            }
        }
        return answer;
    }
}

