/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ElementKind;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.MethodType;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.internal.engine.MethodValidationConfiguration;
import org.hibernate.validator.internal.engine.groups.Sequence;
import org.hibernate.validator.internal.engine.groups.ValidationOrder;
import org.hibernate.validator.internal.engine.groups.ValidationOrderGenerator;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ExecutableMetaData;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.aggregated.PropertyMetaData;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.BeanDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ExecutableDescriptorImpl;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ExecutableHelper;
import org.hibernate.validator.internal.util.classhierarchy.ClassHierarchyHelper;
import org.hibernate.validator.internal.util.classhierarchy.Filters;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.spi.group.DefaultGroupSequenceProvider;

public final class BeanMetaDataImpl<T>
implements BeanMetaData<T> {
    private static final Log log = LoggerFactory.make();
    private static final List<Class<?>> DEFAULT_GROUP_SEQUENCE = Collections.singletonList(Default.class);
    private final ValidationOrderGenerator validationOrderGenerator;
    private final Class<T> beanClass;
    private final Set<MetaConstraint<?>> allMetaConstraints;
    private final Set<MetaConstraint<?>> directMetaConstraints;
    private final Map<String, ExecutableMetaData> executableMetaDataMap;
    private final Map<String, PropertyMetaData> propertyMetaDataMap;
    private final Set<Cascadable> cascadedProperties;
    private final BeanDescriptor beanDescriptor;
    private final List<Class<?>> defaultGroupSequence;
    private final DefaultGroupSequenceProvider<? super T> defaultGroupSequenceProvider;
    private final ValidationOrder validationOrder;
    private final List<Class<? super T>> classHierarchyWithoutInterfaces;

    public BeanMetaDataImpl(Class<T> beanClass, List<Class<?>> defaultGroupSequence, DefaultGroupSequenceProvider<? super T> defaultGroupSequenceProvider, Set<ConstraintMetaData> constraintMetaDataSet, ValidationOrderGenerator validationOrderGenerator) {
        this.validationOrderGenerator = validationOrderGenerator;
        this.beanClass = beanClass;
        this.propertyMetaDataMap = CollectionHelper.newHashMap();
        HashSet<PropertyMetaData> propertyMetaDataSet = CollectionHelper.newHashSet();
        HashSet<ExecutableMetaData> executableMetaDataSet = CollectionHelper.newHashSet();
        for (ConstraintMetaData constraintMetaData : constraintMetaDataSet) {
            if (constraintMetaData.getKind() == ElementKind.PROPERTY) {
                propertyMetaDataSet.add((PropertyMetaData)constraintMetaData);
                continue;
            }
            executableMetaDataSet.add((ExecutableMetaData)constraintMetaData);
        }
        HashSet cascadedProperties = CollectionHelper.newHashSet();
        HashSet allMetaConstraints = CollectionHelper.newHashSet();
        for (PropertyMetaData propertyMetaData : propertyMetaDataSet) {
            this.propertyMetaDataMap.put(propertyMetaData.getName(), propertyMetaData);
            if (propertyMetaData.isCascading()) {
                cascadedProperties.add(propertyMetaData);
            } else {
                allMetaConstraints.addAll(propertyMetaData.getTypeArgumentsConstraints());
            }
            allMetaConstraints.addAll(propertyMetaData.getConstraints());
        }
        this.cascadedProperties = Collections.unmodifiableSet(cascadedProperties);
        this.allMetaConstraints = Collections.unmodifiableSet(allMetaConstraints);
        this.classHierarchyWithoutInterfaces = ClassHierarchyHelper.getHierarchy(beanClass, Filters.excludeInterfaces());
        DefaultGroupSequenceContext<? super T> defaultGroupContext = BeanMetaDataImpl.getDefaultGroupSequenceData(beanClass, defaultGroupSequence, defaultGroupSequenceProvider, validationOrderGenerator);
        this.defaultGroupSequenceProvider = defaultGroupContext.defaultGroupSequenceProvider;
        this.defaultGroupSequence = Collections.unmodifiableList(defaultGroupContext.defaultGroupSequence);
        this.validationOrder = defaultGroupContext.validationOrder;
        this.directMetaConstraints = this.getDirectConstraints();
        this.executableMetaDataMap = Collections.unmodifiableMap(this.bySignature(executableMetaDataSet));
        boolean defaultGroupSequenceIsRedefined = this.defaultGroupSequenceIsRedefined();
        List<Class<?>> resolvedDefaultGroupSequence = this.getDefaultGroupSequence(null);
        Map<String, PropertyDescriptor> propertyDescriptors = BeanMetaDataImpl.getConstrainedPropertiesAsDescriptors(this.propertyMetaDataMap, defaultGroupSequenceIsRedefined, resolvedDefaultGroupSequence);
        Map<String, ExecutableDescriptorImpl> methodsDescriptors = BeanMetaDataImpl.getConstrainedMethodsAsDescriptors(this.executableMetaDataMap, defaultGroupSequenceIsRedefined, resolvedDefaultGroupSequence);
        Map<String, ConstructorDescriptor> constructorsDescriptors = BeanMetaDataImpl.getConstrainedConstructorsAsDescriptors(this.executableMetaDataMap, defaultGroupSequenceIsRedefined, resolvedDefaultGroupSequence);
        this.beanDescriptor = new BeanDescriptorImpl(beanClass, this.getClassLevelConstraintsAsDescriptors(), propertyDescriptors, methodsDescriptors, constructorsDescriptors, defaultGroupSequenceIsRedefined, resolvedDefaultGroupSequence);
    }

    @Override
    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public boolean hasConstraints() {
        return this.beanDescriptor.isBeanConstrained() || !this.beanDescriptor.getConstrainedConstructors().isEmpty() || !this.beanDescriptor.getConstrainedMethods(MethodType.NON_GETTER, new MethodType[]{MethodType.GETTER}).isEmpty();
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public Set<Cascadable> getCascadables() {
        return this.cascadedProperties;
    }

    @Override
    public PropertyMetaData getMetaDataFor(String propertyName) {
        return this.propertyMetaDataMap.get(propertyName);
    }

    @Override
    public Set<MetaConstraint<?>> getMetaConstraints() {
        return this.allMetaConstraints;
    }

    @Override
    public Set<MetaConstraint<?>> getDirectMetaConstraints() {
        return this.directMetaConstraints;
    }

    @Override
    public ExecutableMetaData getMetaDataFor(ExecutableElement executable) {
        return this.executableMetaDataMap.get(executable.getSignature());
    }

    @Override
    public List<Class<?>> getDefaultGroupSequence(T beanState) {
        if (this.hasDefaultGroupSequenceProvider()) {
            List<Class<?>> providerDefaultGroupSequence = this.defaultGroupSequenceProvider.getValidationGroups(beanState);
            return BeanMetaDataImpl.getValidDefaultGroupSequence(this.beanClass, providerDefaultGroupSequence);
        }
        return this.defaultGroupSequence;
    }

    @Override
    public Iterator<Sequence> getDefaultValidationSequence(T beanState) {
        if (this.hasDefaultGroupSequenceProvider()) {
            List<Class<?>> providerDefaultGroupSequence = this.defaultGroupSequenceProvider.getValidationGroups(beanState);
            return this.validationOrderGenerator.getDefaultValidationOrder(this.beanClass, BeanMetaDataImpl.getValidDefaultGroupSequence(this.beanClass, providerDefaultGroupSequence)).getSequenceIterator();
        }
        return this.validationOrder.getSequenceIterator();
    }

    @Override
    public boolean defaultGroupSequenceIsRedefined() {
        return this.defaultGroupSequence.size() > 1 || this.hasDefaultGroupSequenceProvider();
    }

    @Override
    public List<Class<? super T>> getClassHierarchy() {
        return this.classHierarchyWithoutInterfaces;
    }

    private Set<ConstraintDescriptorImpl<?>> getClassLevelConstraintsAsDescriptors() {
        Set<MetaConstraint<?>> classLevelConstraints = this.getClassLevelConstraints(this.allMetaConstraints);
        HashSet<ConstraintDescriptorImpl<?>> theValue = CollectionHelper.newHashSet();
        for (MetaConstraint<?> metaConstraint : classLevelConstraints) {
            theValue.add(metaConstraint.getDescriptor());
        }
        return theValue;
    }

    private static Map<String, PropertyDescriptor> getConstrainedPropertiesAsDescriptors(Map<String, PropertyMetaData> propertyMetaDataMap, boolean defaultGroupSequenceIsRedefined, List<Class<?>> resolvedDefaultGroupSequence) {
        HashMap<String, PropertyDescriptor> theValue = CollectionHelper.newHashMap();
        for (Map.Entry<String, PropertyMetaData> entry : propertyMetaDataMap.entrySet()) {
            if (!entry.getValue().isConstrained() || entry.getValue().getName() == null) continue;
            theValue.put(entry.getKey(), (PropertyDescriptor)entry.getValue().asDescriptor(defaultGroupSequenceIsRedefined, (List)resolvedDefaultGroupSequence));
        }
        return theValue;
    }

    private static Map<String, ExecutableDescriptorImpl> getConstrainedMethodsAsDescriptors(Map<String, ExecutableMetaData> executableMetaDataMap, boolean defaultGroupSequenceIsRedefined, List<Class<?>> resolvedDefaultGroupSequence) {
        HashMap<String, ExecutableDescriptorImpl> constrainedMethodDescriptors = CollectionHelper.newHashMap();
        for (ExecutableMetaData executableMetaData : executableMetaDataMap.values()) {
            if (executableMetaData.getKind() != ElementKind.METHOD || !executableMetaData.isConstrained()) continue;
            ElementDescriptor descriptor = executableMetaData.asDescriptor(defaultGroupSequenceIsRedefined, (List)resolvedDefaultGroupSequence);
            for (String signature : executableMetaData.getSignatures()) {
                constrainedMethodDescriptors.put(signature, (ExecutableDescriptorImpl)descriptor);
            }
        }
        return constrainedMethodDescriptors;
    }

    private static Map<String, ConstructorDescriptor> getConstrainedConstructorsAsDescriptors(Map<String, ExecutableMetaData> executableMetaDataMap, boolean defaultGroupSequenceIsRedefined, List<Class<?>> resolvedDefaultGroupSequence) {
        HashMap<String, ConstructorDescriptor> constrainedMethodDescriptors = CollectionHelper.newHashMap();
        for (ExecutableMetaData executableMetaData : executableMetaDataMap.values()) {
            if (executableMetaData.getKind() != ElementKind.CONSTRUCTOR || !executableMetaData.isConstrained()) continue;
            constrainedMethodDescriptors.put(executableMetaData.getSignatures().iterator().next(), (ConstructorDescriptor)executableMetaData.asDescriptor(defaultGroupSequenceIsRedefined, (List)resolvedDefaultGroupSequence));
        }
        return constrainedMethodDescriptors;
    }

    private static <T> DefaultGroupSequenceContext<T> getDefaultGroupSequenceData(Class<?> beanClass, List<Class<?>> defaultGroupSequence, DefaultGroupSequenceProvider<? super T> defaultGroupSequenceProvider, ValidationOrderGenerator validationOrderGenerator) {
        if (defaultGroupSequence != null && defaultGroupSequenceProvider != null) {
            throw log.getInvalidDefaultGroupSequenceDefinitionException();
        }
        DefaultGroupSequenceContext context = new DefaultGroupSequenceContext();
        if (defaultGroupSequenceProvider != null) {
            context.defaultGroupSequenceProvider = defaultGroupSequenceProvider;
            context.defaultGroupSequence = Collections.emptyList();
            context.validationOrder = null;
        } else if (defaultGroupSequence != null && !defaultGroupSequence.isEmpty()) {
            context.defaultGroupSequence = BeanMetaDataImpl.getValidDefaultGroupSequence(beanClass, defaultGroupSequence);
            context.validationOrder = validationOrderGenerator.getDefaultValidationOrder(beanClass, context.defaultGroupSequence);
        } else {
            context.defaultGroupSequence = DEFAULT_GROUP_SEQUENCE;
            context.validationOrder = ValidationOrder.DEFAULT_SEQUENCE;
        }
        return context;
    }

    private Set<MetaConstraint<?>> getClassLevelConstraints(Set<MetaConstraint<?>> constraints) {
        Set<MetaConstraint<?>> classLevelConstraints = CollectionHelper.partition(constraints, this.byElementType()).get((Object)ElementType.TYPE);
        return classLevelConstraints != null ? classLevelConstraints : Collections.emptySet();
    }

    private Set<MetaConstraint<?>> getDirectConstraints() {
        HashSet constraints = CollectionHelper.newHashSet();
        HashSet<Class> classAndInterfaces = CollectionHelper.newHashSet();
        classAndInterfaces.add(this.beanClass);
        classAndInterfaces.addAll(ClassHierarchyHelper.getDirectlyImplementedInterfaces(this.beanClass));
        for (Class clazz : classAndInterfaces) {
            for (MetaConstraint<?> metaConstraint : this.allMetaConstraints) {
                if (!metaConstraint.getLocation().getDeclaringClass().equals(clazz)) continue;
                constraints.add(metaConstraint);
            }
        }
        return Collections.unmodifiableSet(constraints);
    }

    private Map<String, ExecutableMetaData> bySignature(Set<ExecutableMetaData> executables) {
        HashMap<String, ExecutableMetaData> theValue = CollectionHelper.newHashMap();
        for (ExecutableMetaData executableMetaData : executables) {
            for (String signature : executableMetaData.getSignatures()) {
                theValue.put(signature, executableMetaData);
            }
        }
        return theValue;
    }

    private static List<Class<?>> getValidDefaultGroupSequence(Class<?> beanClass, List<Class<?>> groupSequence) {
        ArrayList validDefaultGroupSequence = new ArrayList();
        boolean groupSequenceContainsDefault = false;
        if (groupSequence != null) {
            for (Class<?> group : groupSequence) {
                if (group.getName().equals(beanClass.getName())) {
                    validDefaultGroupSequence.add(Default.class);
                    groupSequenceContainsDefault = true;
                    continue;
                }
                if (group.getName().equals(Default.class.getName())) {
                    throw log.getNoDefaultGroupInGroupSequenceException();
                }
                validDefaultGroupSequence.add(group);
            }
        }
        if (!groupSequenceContainsDefault) {
            throw log.getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException(beanClass);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Members of the default group sequence for bean %s are: %s.", beanClass.getName(), validDefaultGroupSequence);
        }
        return validDefaultGroupSequence;
    }

    private boolean hasDefaultGroupSequenceProvider() {
        return this.defaultGroupSequenceProvider != null;
    }

    private CollectionHelper.Partitioner<ElementType, MetaConstraint<?>> byElementType() {
        return new CollectionHelper.Partitioner<ElementType, MetaConstraint<?>>(){

            @Override
            public ElementType getPartition(MetaConstraint<?> constraint) {
                return constraint.getElementType();
            }
        };
    }

    public String toString() {
        return "BeanMetaDataImpl{beanClass=" + this.beanClass.getSimpleName() + ", constraintCount=" + this.getMetaConstraints().size() + ", cascadedPropertiesCount=" + this.cascadedProperties.size() + ", defaultGroupSequence=" + this.getDefaultGroupSequence(null) + '}';
    }

    private static class DefaultGroupSequenceContext<T> {
        List<Class<?>> defaultGroupSequence;
        DefaultGroupSequenceProvider<? super T> defaultGroupSequenceProvider;
        ValidationOrder validationOrder;

        private DefaultGroupSequenceContext() {
        }
    }

    private static class BuilderDelegate {
        private final Class<?> beanClass;
        private final ConstraintHelper constraintHelper;
        private final ExecutableHelper executableHelper;
        private MetaDataBuilder propertyBuilder;
        private ExecutableMetaData.Builder methodBuilder;
        private final MethodValidationConfiguration methodValidationConfiguration;

        public BuilderDelegate(Class<?> beanClass, ConstrainedElement constrainedElement, ConstraintHelper constraintHelper, ExecutableHelper executableHelper, MethodValidationConfiguration methodValidationConfiguration) {
            this.beanClass = beanClass;
            this.constraintHelper = constraintHelper;
            this.executableHelper = executableHelper;
            this.methodValidationConfiguration = methodValidationConfiguration;
            switch (constrainedElement.getKind()) {
                case FIELD: {
                    ConstrainedField constrainedField = (ConstrainedField)constrainedElement;
                    this.propertyBuilder = new PropertyMetaData.Builder(beanClass, constrainedField, constraintHelper);
                    break;
                }
                case CONSTRUCTOR: 
                case METHOD: {
                    ConstrainedExecutable constrainedExecutable = (ConstrainedExecutable)constrainedElement;
                    Member member = constrainedExecutable.getExecutable().getMember();
                    if (!Modifier.isPrivate(member.getModifiers()) || beanClass == member.getDeclaringClass()) {
                        this.methodBuilder = new ExecutableMetaData.Builder(beanClass, constrainedExecutable, constraintHelper, executableHelper, methodValidationConfiguration);
                    }
                    if (!constrainedExecutable.isGetterMethod()) break;
                    this.propertyBuilder = new PropertyMetaData.Builder(beanClass, constrainedExecutable, constraintHelper);
                    break;
                }
                case TYPE: {
                    ConstrainedType constrainedType = (ConstrainedType)constrainedElement;
                    this.propertyBuilder = new PropertyMetaData.Builder(beanClass, constrainedType, constraintHelper);
                }
            }
        }

        public boolean add(ConstrainedElement constrainedElement) {
            boolean added = false;
            if (this.methodBuilder != null && this.methodBuilder.accepts(constrainedElement)) {
                this.methodBuilder.add(constrainedElement);
                added = true;
            }
            if (this.propertyBuilder != null && this.propertyBuilder.accepts(constrainedElement)) {
                this.propertyBuilder.add(constrainedElement);
                if (!added && constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.METHOD && this.methodBuilder == null) {
                    ConstrainedExecutable constrainedMethod = (ConstrainedExecutable)constrainedElement;
                    this.methodBuilder = new ExecutableMetaData.Builder(this.beanClass, constrainedMethod, this.constraintHelper, this.executableHelper, this.methodValidationConfiguration);
                }
                added = true;
            }
            return added;
        }

        public Set<ConstraintMetaData> build() {
            HashSet<ConstraintMetaData> metaDataSet = CollectionHelper.newHashSet();
            if (this.propertyBuilder != null) {
                metaDataSet.add(this.propertyBuilder.build());
            }
            if (this.methodBuilder != null) {
                metaDataSet.add(this.methodBuilder.build());
            }
            return metaDataSet;
        }
    }

    public static class BeanMetaDataBuilder<T> {
        private final ConstraintHelper constraintHelper;
        private final ValidationOrderGenerator validationOrderGenerator;
        private final Class<T> beanClass;
        private final Set<BuilderDelegate> builders = CollectionHelper.newHashSet();
        private final ExecutableHelper executableHelper;
        private ConfigurationSource sequenceSource;
        private ConfigurationSource providerSource;
        private List<Class<?>> defaultGroupSequence;
        private DefaultGroupSequenceProvider<? super T> defaultGroupSequenceProvider;
        private final MethodValidationConfiguration methodValidationConfiguration;

        private BeanMetaDataBuilder(ConstraintHelper constraintHelper, ExecutableHelper executableHelper, ValidationOrderGenerator validationOrderGenerator, Class<T> beanClass, MethodValidationConfiguration methodValidationConfiguration) {
            this.beanClass = beanClass;
            this.constraintHelper = constraintHelper;
            this.validationOrderGenerator = validationOrderGenerator;
            this.executableHelper = executableHelper;
            this.methodValidationConfiguration = methodValidationConfiguration;
        }

        public static <T> BeanMetaDataBuilder<T> getInstance(ConstraintHelper constraintHelper, ExecutableHelper executableHelper, ValidationOrderGenerator validationOrderGenerator, Class<T> beanClass, MethodValidationConfiguration methodValidationConfiguration) {
            return new BeanMetaDataBuilder<T>(constraintHelper, executableHelper, validationOrderGenerator, beanClass, methodValidationConfiguration);
        }

        public void add(BeanConfiguration<? super T> configuration) {
            if (configuration.getBeanClass().equals(this.beanClass)) {
                if (configuration.getDefaultGroupSequence() != null && (this.sequenceSource == null || configuration.getSource().getPriority() >= this.sequenceSource.getPriority())) {
                    this.sequenceSource = configuration.getSource();
                    this.defaultGroupSequence = configuration.getDefaultGroupSequence();
                }
                if (configuration.getDefaultGroupSequenceProvider() != null && (this.providerSource == null || configuration.getSource().getPriority() >= this.providerSource.getPriority())) {
                    this.providerSource = configuration.getSource();
                    this.defaultGroupSequenceProvider = configuration.getDefaultGroupSequenceProvider();
                }
            }
            for (ConstrainedElement constrainedElement : configuration.getConstrainedElements()) {
                this.addMetaDataToBuilder(constrainedElement, this.builders);
            }
        }

        private void addMetaDataToBuilder(ConstrainedElement constrainableElement, Set<BuilderDelegate> builders) {
            for (BuilderDelegate builder : builders) {
                boolean foundBuilder = builder.add(constrainableElement);
                if (!foundBuilder) continue;
                return;
            }
            builders.add(new BuilderDelegate(this.beanClass, constrainableElement, this.constraintHelper, this.executableHelper, this.methodValidationConfiguration));
        }

        public BeanMetaDataImpl<T> build() {
            HashSet<ConstraintMetaData> aggregatedElements = CollectionHelper.newHashSet();
            for (BuilderDelegate builder : this.builders) {
                aggregatedElements.addAll(builder.build());
            }
            return new BeanMetaDataImpl<T>(this.beanClass, this.defaultGroupSequence, this.defaultGroupSequenceProvider, aggregatedElements, this.validationOrderGenerator);
        }
    }
}

