/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.kex;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Objects;
import org.apache.sshd.common.kex.dh.AbstractDHKeyExchange;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionHolder;

public abstract class AbstractDHServerKeyExchange
extends AbstractDHKeyExchange
implements ServerSessionHolder {
    protected AbstractDHServerKeyExchange(Session s) {
        super(ValidateUtils.checkInstanceOf((Object)s, ServerSession.class, "Using a client side KeyExchange on a server: %s", (Object)s));
    }

    @Override
    public final ServerSession getServerSession() {
        return (ServerSession)this.getSession();
    }

    @Override
    public PublicKey getServerKey() {
        ServerSession session = this.getServerSession();
        KeyPair kpHost = Objects.requireNonNull(session.getHostKey(), "No server key pair available");
        return kpHost.getPublic();
    }
}

