/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.cm.NotCachablePersistenceManager;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.ActivatorWorkerQueue;
import org.apache.felix.cm.impl.ConfigurationAdminStarter;
import org.apache.felix.cm.impl.persistence.CachingPersistenceManagerProxy;
import org.apache.felix.cm.impl.persistence.ExtPersistenceManager;
import org.apache.felix.cm.impl.persistence.PersistenceManagerProxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PersistenceManagerTracker
implements ServiceTrackerCustomizer<PersistenceManager, Holder> {
    private final List<Holder> holders = new ArrayList<Holder>();
    private final ServiceTracker<PersistenceManager, Holder> persistenceManagerTracker;
    private final BundleContext bundleContext;
    private final ActivatorWorkerQueue workerQueue;
    private final ConfigurationAdminStarter starter;

    public PersistenceManagerTracker(BundleContext bundleContext, ActivatorWorkerQueue workerQueue, ConfigurationAdminStarter starter, String pmName) throws BundleException, InvalidSyntaxException {
        this.workerQueue = workerQueue;
        this.starter = starter;
        this.bundleContext = bundleContext;
        this.persistenceManagerTracker = new ServiceTracker(bundleContext, bundleContext.createFilter("(&(objectClass=" + PersistenceManager.class.getName() + ")(name=" + pmName + "))"), (ServiceTrackerCustomizer)this);
        this.persistenceManagerTracker.open();
    }

    public void stop() {
        this.persistenceManagerTracker.close();
    }

    public static ExtPersistenceManager createPersistenceManagerProxy(PersistenceManager pm) {
        ExtPersistenceManager extPM = pm instanceof NotCachablePersistenceManager ? new PersistenceManagerProxy(pm) : new CachingPersistenceManagerProxy(pm);
        return extPM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Holder addingService(ServiceReference<PersistenceManager> reference) {
        PersistenceManager pm = (PersistenceManager)this.bundleContext.getService(reference);
        if (pm != null) {
            ExtPersistenceManager extPM = PersistenceManagerTracker.createPersistenceManagerProxy(pm);
            final Holder holder = new Holder(reference, extPM);
            List<Holder> list = this.holders;
            synchronized (list) {
                final Holder oldHolder = this.holders.isEmpty() ? null : this.holders.get(0);
                this.holders.add(holder);
                Collections.sort(this.holders);
                if (this.holders.get(0) == holder) {
                    this.workerQueue.enqueue(new Runnable(){

                        @Override
                        public void run() {
                            if (oldHolder != null) {
                                PersistenceManagerTracker.this.starter.unsetPersistenceManager();
                            }
                            if (!holder.isActivated()) {
                                PersistenceManagerTracker.this.starter.setPersistenceManager(holder.getPersistenceManager());
                                holder.activate();
                            }
                        }
                    });
                }
            }
            return holder;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference<PersistenceManager> reference, final Holder holder) {
        List<Holder> list = this.holders;
        synchronized (list) {
            Holder oldHolder = this.holders.isEmpty() ? null : this.holders.get(0);
            this.holders.remove(holder);
            this.holders.add(new Holder(reference, holder.getPersistenceManager()));
            Collections.sort(this.holders);
            if (this.holders.get(0) == holder && oldHolder != null && oldHolder.compareTo(holder) != 0) {
                this.workerQueue.enqueue(new Runnable(){

                    @Override
                    public void run() {
                        PersistenceManagerTracker.this.starter.unsetPersistenceManager();
                        if (!holder.isActivated()) {
                            PersistenceManagerTracker.this.starter.setPersistenceManager(holder.getPersistenceManager());
                            holder.activate();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<PersistenceManager> reference, Holder holder) {
        List<Holder> list = this.holders;
        synchronized (list) {
            boolean deactivate = this.holders.get(0) == holder;
            this.holders.remove(holder);
            if (deactivate) {
                this.workerQueue.enqueue(new Runnable(){

                    @Override
                    public void run() {
                        Holder h;
                        PersistenceManagerTracker.this.starter.unsetPersistenceManager();
                        if (!PersistenceManagerTracker.this.holders.isEmpty() && !(h = (Holder)PersistenceManagerTracker.this.holders.get(0)).isActivated()) {
                            PersistenceManagerTracker.this.starter.setPersistenceManager(h.getPersistenceManager());
                            h.activate();
                        }
                    }
                });
            }
        }
    }

    public static final class Holder
    implements Comparable<Holder> {
        private final ServiceReference<PersistenceManager> reference;
        private final ExtPersistenceManager manager;
        private boolean activated;

        public Holder(ServiceReference<PersistenceManager> ref, ExtPersistenceManager epm) {
            this.reference = ref;
            this.manager = epm;
        }

        public ExtPersistenceManager getPersistenceManager() {
            return this.manager;
        }

        @Override
        public int compareTo(Holder o) {
            return -this.reference.compareTo(o.reference);
        }

        public boolean isActivated() {
            return this.activated;
        }

        public void activate() {
            this.activated = true;
        }

        public int hashCode() {
            return this.reference.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Holder other = (Holder)obj;
            return this.reference.equals(other.reference);
        }
    }
}

