/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.spi;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.spi.GeneratedClassClassLoaderCapture;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.WeakIdentityHashMap;

public class ClassGeneratorClassLoader {
    protected static final Map<Class<?>, WeakReference<TypeHelperClassLoader>> CLASS_MAP = new WeakIdentityHashMap();
    protected static final Map<ClassLoader, WeakReference<TypeHelperClassLoader>> LOADER_MAP = new WeakIdentityHashMap<ClassLoader, WeakReference<TypeHelperClassLoader>>();
    protected final Bus bus;

    public ClassGeneratorClassLoader(Bus bus) {
        this.bus = bus == null ? BusFactory.getDefaultBus() : bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClass(String className, Class<?> cls, byte[] bytes) {
        TypeHelperClassLoader loader;
        GeneratedClassClassLoaderCapture capture = this.bus.getExtension(GeneratedClassClassLoaderCapture.class);
        if (capture != null) {
            capture.capture(className, bytes);
        }
        TypeHelperClassLoader typeHelperClassLoader = loader = ClassGeneratorClassLoader.getOrCreateLoader(cls);
        synchronized (typeHelperClassLoader) {
            Class<?> clz = loader.lookupDefinedClass(className);
            if (clz == null) {
                return loader.defineClass(className, bytes);
            }
            return clz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClass(String className, ClassLoader l, byte[] bytes) {
        TypeHelperClassLoader loader;
        GeneratedClassClassLoaderCapture capture = this.bus.getExtension(GeneratedClassClassLoaderCapture.class);
        if (capture != null) {
            capture.capture(className, bytes);
        }
        TypeHelperClassLoader typeHelperClassLoader = loader = ClassGeneratorClassLoader.getOrCreateLoader(l);
        synchronized (typeHelperClassLoader) {
            Class<?> clz = loader.lookupDefinedClass(className);
            if (clz == null) {
                return loader.defineClass(className, bytes);
            }
            return clz;
        }
    }

    protected Class<?> findClass(String className, Class<?> cls) {
        return ClassGeneratorClassLoader.getOrCreateLoader(cls).lookupDefinedClass(className);
    }

    protected Class<?> findClass(String className, ClassLoader classLoader) {
        return ClassGeneratorClassLoader.getOrCreateLoader(classLoader).lookupDefinedClass(className);
    }

    private static synchronized TypeHelperClassLoader getOrCreateLoader(Class<?> cls) {
        TypeHelperClassLoader ret;
        WeakReference<TypeHelperClassLoader> ref = CLASS_MAP.get(cls);
        if (ref == null || ref.get() == null) {
            ret = new TypeHelperClassLoader(cls.getClassLoader());
            CLASS_MAP.put(cls, new WeakReference<TypeHelperClassLoader>(ret));
        } else {
            ret = (TypeHelperClassLoader)ref.get();
        }
        return ret;
    }

    private static synchronized TypeHelperClassLoader getOrCreateLoader(ClassLoader l) {
        TypeHelperClassLoader ret;
        WeakReference<TypeHelperClassLoader> ref = LOADER_MAP.get(l);
        if (ref == null || ref.get() == null) {
            ret = new TypeHelperClassLoader(l);
            LOADER_MAP.put(l, new WeakReference<TypeHelperClassLoader>(ret));
        } else {
            ret = (TypeHelperClassLoader)ref.get();
        }
        return ret;
    }

    public static class TypeHelperClassLoader
    extends ClassLoader {
        private final ConcurrentHashMap<String, Class<?>> defined = new ConcurrentHashMap();

        TypeHelperClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> lookupDefinedClass(String name) {
            return this.defined.get(StringUtils.slashesToPeriod(name));
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.endsWith("package-info")) {
                return this.getParent().loadClass(name);
            }
            return super.findClass(name);
        }

        public Class<?> defineClass(String name, byte[] bytes) {
            String s;
            Package p;
            Class ret = this.defined.get(StringUtils.slashesToPeriod(name));
            if (ret != null) {
                return ret;
            }
            if (name.endsWith("package-info") && (p = super.getPackage(s = name.substring(0, name.length() - 13))) == null) {
                this.definePackage(StringUtils.slashesToPeriod(s), null, null, null, null, null, null, null);
            }
            ret = this.defined.computeIfAbsent(StringUtils.slashesToPeriod(name), key -> TypeHelperClassLoader.super.defineClass(key, bytes, 0, bytes.length));
            return ret;
        }
    }
}

