/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.groovy.actions.rest;

import java.io.IOException;
import java.io.InputStream;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.groovy.actions.services.GroovyActionsService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Produces(value={"application/json;charset=UTF-8"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/groovyActions")
@Component(service={GroovyActionsEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class GroovyActionsEndPoint {
    private static final Logger logger = LoggerFactory.getLogger((String)GroovyActionsEndPoint.class.getName());
    @Reference
    private GroovyActionsService groovyActionsService;

    public GroovyActionsEndPoint() {
        logger.info("Initializing groovy actions service endpoint...");
    }

    @WebMethod(exclude=true)
    public void setGroovyActionsService(GroovyActionsService groovyActionsService) {
        this.groovyActionsService = groovyActionsService;
    }

    @POST
    @Path(value="/")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response save(@Multipart(value="file") Attachment file) {
        try {
            this.groovyActionsService.save(file.getContentDisposition().getFilename().replace(".groovy", ""), IOUtils.toString((InputStream)file.getDataHandler().getInputStream()));
        }
        catch (IOException e) {
            logger.error("Error while processing groovy file", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{actionId}")
    public void remove(@PathParam(value="actionId") String actionId) {
        this.groovyActionsService.remove(actionId);
    }
}

