/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast.factory;

import com.hazelcast.config.Config;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.XmlConfigBuilder;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.cellar.core.discovery.DiscoveryService;
import org.apache.karaf.cellar.core.utils.CellarUtils;
import org.apache.karaf.cellar.hazelcast.factory.HazelcastServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastConfigurationManager {
    static final transient Logger LOGGER = LoggerFactory.getLogger(HazelcastServiceFactory.class);
    private String xmlConfigLocation = System.getProperty("karaf.etc") + File.separator + "hazelcast.xml";
    private Set<String> discoveredMemberSet = new LinkedHashSet<String>();
    private List<DiscoveryService> discoveryServices;
    private TcpIpConfig tcpIpConfig;

    public Config getHazelcastConfig() {
        System.setProperty("hazelcast.config", this.xmlConfigLocation);
        Config config = new XmlConfigBuilder().build();
        if (System.getProperty("hazelcast.instanceName") != null) {
            config.setInstanceName(System.getProperty("hazelcast.instanceName"));
        } else {
            config.setInstanceName("cellar");
        }
        if (config.getNetworkConfig().getJoin().getTcpIpConfig().isEnabled() && this.discoveredMemberSet != null) {
            if (this.discoveryServices != null && !this.discoveryServices.isEmpty()) {
                for (DiscoveryService service : this.discoveryServices) {
                    service.refresh();
                    Set discovered = service.discoverMembers();
                    this.discoveredMemberSet.addAll(discovered);
                    LOGGER.trace("HAZELCAST STARTUP DISCOVERY: service {} found members {}", (Object)service, (Object)discovered);
                }
            }
            this.tcpIpConfig = config.getNetworkConfig().getJoin().getTcpIpConfig();
            this.tcpIpConfig.getMembers().addAll(this.discoveredMemberSet);
        }
        return config;
    }

    public boolean isUpdated(Map properties) {
        Set newDiscoveredMemberSet;
        Boolean updated = Boolean.FALSE;
        if (properties != null && properties.containsKey("discoveredMembers") && !CellarUtils.collectionEquals(this.discoveredMemberSet, (Collection)(newDiscoveredMemberSet = CellarUtils.createSetFromString((String)((String)properties.get("discoveredMembers")))))) {
            LOGGER.debug("Hazelcast discoveredMemberSet has been changed from {} to {}", this.discoveredMemberSet, (Object)newDiscoveredMemberSet);
            this.discoveredMemberSet = newDiscoveredMemberSet;
            for (String discoveredMember : this.discoveredMemberSet) {
                if (discoveredMember == null || String.valueOf(discoveredMember).equals("null") || this.tcpIpConfig.getMembers().contains(discoveredMember)) continue;
                this.tcpIpConfig.getMembers().add(discoveredMember);
            }
            Iterator iterator = this.tcpIpConfig.getMembers().iterator();
            while (iterator.hasNext()) {
                String member = (String)iterator.next();
                if (this.discoveredMemberSet.contains(member)) continue;
                iterator.remove();
            }
            updated = Boolean.TRUE;
        }
        return updated;
    }

    public void setDiscoveryServices(List<DiscoveryService> discoveryServices) {
        this.discoveryServices = discoveryServices;
    }

    protected Set<String> getDiscoveredMemberSet() {
        return this.discoveredMemberSet;
    }
}

