/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.spi;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;
import org.apache.karaf.specs.locator.OsgiLocator;

class $FactoryFinder {
    private static final Logger LOGGER = Logger.getLogger("javax.xml.ws");

    $FactoryFinder() {
    }

    static <T> T find(Class<T> factoryClass, String fallbackClassName) {
        ClassLoader classLoader = $FactoryFinder.contextClassLoader();
        Object provider = $FactoryFinder.firstByServiceLoader(factoryClass);
        if (provider != null) {
            return provider;
        }
        String factoryId = factoryClass.getName();
        provider = $FactoryFinder.fromJDKProperties(factoryId, fallbackClassName, classLoader);
        if (provider != null) {
            return provider;
        }
        provider = $FactoryFinder.fromSystemProperty(factoryId, fallbackClassName, classLoader);
        if (provider != null) {
            return provider;
        }
        try {
            Class spiClass = OsgiLocator.locate(factoryClass);
            if (spiClass != null) {
                return spiClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (fallbackClassName == null) {
            throw new WebServiceException("Provider for " + factoryId + " cannot be found", null);
        }
        return (T)$FactoryFinder.newInstance(fallbackClassName, fallbackClassName, classLoader);
    }

    private static Object fromSystemProperty(String factoryId, String fallbackClassName, ClassLoader classLoader) {
        try {
            String systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return $FactoryFinder.newInstance(systemProp, fallbackClassName, classLoader);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private static Object fromJDKProperties(String factoryId, String fallbackClassName, ClassLoader classLoader) {
        block15: {
            Path path = null;
            try {
                String JAVA_HOME = System.getProperty("java.home");
                path = Paths.get(JAVA_HOME, "conf", "jaxws.properties");
                if (!Files.exists(path, new LinkOption[0])) {
                    path = Paths.get(JAVA_HOME, "lib", "jaxws.properties");
                }
                if (!Files.exists(path, new LinkOption[0])) break block15;
                Properties props = new Properties();
                try (InputStream inStream = Files.newInputStream(path, new OpenOption[0]);){
                    props.load(inStream);
                }
                String factoryClassName = props.getProperty(factoryId);
                return $FactoryFinder.newInstance(factoryClassName, fallbackClassName, classLoader);
            }
            catch (Exception ignored) {
                LOGGER.log(Level.SEVERE, "Error reading JAX-WS configuration from [" + path + "] file. Check it is accessible and has correct format.", ignored);
            }
        }
        return null;
    }

    private static <T> T firstByServiceLoader(Class<T> spiClass) throws WebServiceException {
        LOGGER.log(Level.FINE, "Using java.util.ServiceLoader to find {0}", spiClass.getName());
        try {
            ServiceLoader<T> serviceLoader = ServiceLoader.load(spiClass);
            Iterator<T> iterator = serviceLoader.iterator();
            if (iterator.hasNext()) {
                T impl = iterator.next();
                LOGGER.fine("ServiceProvider loading Facility used; returning object [" + impl.getClass().getName() + "]");
                return impl;
            }
        }
        catch (Throwable t) {
            throw new WebServiceException("Error while searching for service [" + spiClass.getName() + "]", t);
        }
        return null;
    }

    private static void checkPackageAccess(String className) {
        int i;
        SecurityManager s = System.getSecurityManager();
        if (s != null && (i = className.lastIndexOf(46)) != -1) {
            s.checkPackageAccess(className.substring(0, i));
        }
    }

    private static Class nullSafeLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            return Class.forName(className);
        }
        return classLoader.loadClass(className);
    }

    private static Object newInstance(String className, String defaultImplClassName, ClassLoader classLoader) throws WebServiceException {
        try {
            return $FactoryFinder.safeLoadClass(className, defaultImplClassName, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException x) {
            throw new WebServiceException("Provider " + className + " not found", (Throwable)x);
        }
        catch (Exception x) {
            throw new WebServiceException("Provider " + className + " could not be instantiated: " + x, (Throwable)x);
        }
    }

    private static Class<?> safeLoadClass(String className, String defaultImplClassName, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            $FactoryFinder.checkPackageAccess(className);
        }
        catch (SecurityException se) {
            if (defaultImplClassName != null && defaultImplClassName.equals(className)) {
                return Class.forName(className);
            }
            throw se;
        }
        return $FactoryFinder.nullSafeLoadClass(className, classLoader);
    }

    private static ClassLoader contextClassLoader() throws WebServiceException {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception x) {
            throw new WebServiceException(x.toString(), (Throwable)x);
        }
    }
}

