/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.commons.collections4.map.LRUMap;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.osgi.framework.Bundle;

public class ResourceDelegatingBundleClassLoader
extends BundleClassLoader {
    private List<Bundle> bundles;
    private int cacheSize = 100;
    private LRUMap<String, Vector<URL>> lruCache = new LRUMap(this.cacheSize);

    public ResourceDelegatingBundleClassLoader(List<Bundle> bundles) {
        super(bundles.get(0));
        this.bundles = bundles;
    }

    public ResourceDelegatingBundleClassLoader(List<Bundle> bundles, ClassLoader parent) {
        super(bundles.get(0), parent);
        this.bundles = bundles;
    }

    public void addBundle(Bundle bundle) {
        this.bundles.add(bundle);
        this.lruCache.clear();
    }

    public List<Bundle> getBundles() {
        return this.bundles;
    }

    @Override
    protected URL findResource(String name) {
        Enumeration<URL> elements;
        Vector<URL> resources = this.getFromCache(name);
        if (resources == null) {
            resources = new Vector();
            for (Bundle delegate : this.bundles) {
                try {
                    URL resource = delegate.getResource(name);
                    if (resource == null) continue;
                    resources.add(resource);
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                }
            }
            if (!resources.isEmpty()) {
                this.addToCache(name, resources);
            }
        }
        if ((elements = resources.elements()).hasMoreElements()) {
            return elements.nextElement();
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Vector<URL> resources = this.getFromCache(name);
        if (resources == null) {
            resources = new Vector();
            for (Bundle delegate : this.bundles) {
                try {
                    Enumeration urls = delegate.getResources(name);
                    if (urls == null) continue;
                    while (urls.hasMoreElements()) {
                        resources.add((URL)urls.nextElement());
                    }
                }
                catch (IllegalStateException illegalStateException) {
                }
            }
            if (!resources.isEmpty()) {
                this.addToCache(name, resources);
            }
        }
        return resources.elements();
    }

    protected synchronized void addToCache(String name, Vector<URL> resources) {
        this.lruCache.put(name, resources);
    }

    protected Vector<URL> getFromCache(String name) {
        return this.lruCache.get(name);
    }
}

