/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class OneShotExecutionCallback<V>
implements ExecutionCallback<V> {
    private static final AtomicIntegerFieldUpdater CALL_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OneShotExecutionCallback.class, "callState");
    private static final int NOT_CALLED = 0;
    private static final int CALL_IN_PROGRESS = 1;
    private static final int CALL_FINISHED = 2;
    private volatile int callState = 0;

    OneShotExecutionCallback() {
    }

    @Override
    public final void onResponse(V response) {
        this.onInternal(response, false, Long.MAX_VALUE);
    }

    @Override
    public final void onFailure(Throwable t) {
        this.onInternal(t, true, Long.MAX_VALUE);
    }

    void onResponse(V response, long finishTime) {
        this.onInternal(response, false, finishTime);
    }

    void onFailure(Throwable t, long finishTime) {
        this.onInternal(t, true, finishTime);
    }

    protected abstract void onResponseInternal(V var1);

    protected abstract void onFailureInternal(Throwable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInternal(Object obj, boolean failure, long finishTime) {
        if (this.callState != 2) {
            if (CALL_STATE_UPDATER.compareAndSet(this, 0, 1)) {
                try {
                    if (failure) {
                        this.onFailureInternal((Throwable)obj);
                    }
                    this.onResponseInternal(obj);
                }
                finally {
                    this.callState = 2;
                }
            } else {
                while (finishTime > Clock.currentTimeMillis()) {
                    if (this.callState != 2) continue;
                    return;
                }
                ExceptionUtil.sneakyThrow(new TimeoutException("Waiting for sync execution callback to finish has failed due to timeout!"));
            }
        }
    }
}

