/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.schema.api.SchemaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static final int MAX_COOKIE_AGE_IN_SECONDS = 31536000;

    public static String dumpRequestInfo(HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append("======================================================================================\n");
        stringBuilder.append(HttpUtils.dumpBasicRequestInfo(httpServletRequest));
        stringBuilder.append(HttpUtils.dumpRequestHeaders(httpServletRequest));
        stringBuilder.append(HttpUtils.dumpRequestCookies(httpServletRequest.getCookies()));
        stringBuilder.append("======================================================================================\n");
        return stringBuilder.toString();
    }

    public static String dumpBasicRequestInfo(HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(httpServletRequest.getMethod()).append(" ").append(httpServletRequest.getRequestURI());
        if (httpServletRequest.getQueryString() != null) {
            stringBuilder.append("?").append(httpServletRequest.getQueryString());
        }
        stringBuilder.append(" serverName=").append(httpServletRequest.getServerName()).append(" serverPort=").append(httpServletRequest.getServerPort()).append(" remoteAddr=").append(httpServletRequest.getRemoteAddr()).append(" remotePort=").append(httpServletRequest.getRemotePort()).append("\n");
        return stringBuilder.toString();
    }

    public static String dumpRequestCookies(Cookie[] cookies) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cookies:\n");
        if (cookies == null) {
            stringBuilder.append("  none");
        } else {
            for (Cookie cookie : cookies) {
                stringBuilder.append("  ").append(cookie.getName()).append("=").append(cookie.getValue()).append(" domain=").append(cookie.getDomain()).append(" path=").append(cookie.getPath()).append(" maxAge=").append(cookie.getMaxAge()).append(" httpOnly=").append(cookie.isHttpOnly()).append(" secure=").append(cookie.getSecure()).append(" version=").append(cookie.getVersion()).append(" comment=").append(cookie.getComment()).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public static String dumpRequestHeaders(HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Headers:\n");
        Enumeration headerNameEnum = httpServletRequest.getHeaderNames();
        while (headerNameEnum.hasMoreElements()) {
            String headerName = (String)headerNameEnum.nextElement();
            stringBuilder.append("  ").append(headerName).append(": ").append(httpServletRequest.getHeader(headerName)).append("\n");
        }
        return stringBuilder.toString();
    }

    public static String getProfileCookieString(Profile profile, ConfigSharingService configSharingService, boolean isSecure) {
        String profileIdCookieDomain = (String)configSharingService.getProperty("profileIdCookieDomain");
        String profileIdCookieName = (String)configSharingService.getProperty("profileIdCookieName");
        Integer profileIdCookieMaxAgeInSeconds = (Integer)configSharingService.getProperty("profileIdCookieMaxAgeInSeconds");
        Boolean profileIdCookieHttpOnly = (Boolean)configSharingService.getProperty("profileIdCookieHttpOnly");
        return profileIdCookieName + "=" + profile.getItemId() + "; Path=/; Max-Age=" + profileIdCookieMaxAgeInSeconds + (String)(StringUtils.isNotBlank((CharSequence)profileIdCookieDomain) ? "; Domain=" + profileIdCookieDomain : "") + "; SameSite=Lax" + (isSecure ? "; Secure" : "") + (profileIdCookieHttpOnly != false ? "; HttpOnly" : "");
    }

    public static List<Event> filterValidEvents(ArrayNode eventsNode, SchemaService schemaService, JsonParser jsonParser) throws JsonProcessingException {
        ArrayList<Event> filteredEvents = new ArrayList<Event>();
        for (JsonNode event : eventsNode) {
            if (schemaService.isEventValid(event.toString())) {
                filteredEvents.add((Event)jsonParser.getCodec().treeToValue((TreeNode)event, Event.class));
                continue;
            }
            logger.error("An event was rejected - switch to DEBUG log level for more information OR test the payload of your event against the \"validateEvent\" endpoint.");
        }
        return filteredEvents;
    }
}

